/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.test;

import com.netflix.archaius.test.TestConfigException;
import com.netflix.archaius.test.TestPropertyOverride;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

public class TestPropertyOverrideAnnotationReader {
    public Properties getPropertiesForAnnotation(TestPropertyOverride annotation) {
        Properties properties = new Properties();
        if (annotation == null) {
            return properties;
        }
        for (String fileName : annotation.propertyFiles()) {
            try {
                InputStream propFileStream = this.getClass().getClassLoader().getResourceAsStream(fileName);
                if (propFileStream == null) {
                    throw new FileNotFoundException(fileName);
                }
                properties.load(propFileStream);
            }
            catch (IOException e) {
                throw new TestConfigException("Failed to load property file from classpath", e);
            }
        }
        for (String override : annotation.value()) {
            String[] parts = override.split("=", 2);
            if (parts.length < 2) {
                throw new TestConfigException("Error parsing TestPropertyOverride for: " + Arrays.toString(annotation.value()) + " Please ensure you are specifying overrides in the form \"key=value\"");
            }
            properties.put(parts[0], parts[1]);
        }
        return properties;
    }
}

