/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.test;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.test.TestCompositeConfig;
import com.netflix.archaius.test.TestPropertyOverride;
import com.netflix.archaius.test.TestPropertyOverrideAnnotationReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ClassUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class Archaius2TestConfig
implements TestRule,
SettableConfig {
    private TestCompositeConfig testCompositeConfig;
    private final TestPropertyOverrideAnnotationReader annotationReader = new TestPropertyOverrideAnnotationReader();

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                DefaultSettableConfig runtimeLevelProperties = new DefaultSettableConfig();
                DefaultSettableConfig classLevelProperties = new DefaultSettableConfig();
                DefaultSettableConfig methodLevelProperties = new DefaultSettableConfig();
                List allSuperclasses = ClassUtils.getAllSuperclasses((Class)description.getTestClass());
                Collections.reverse(allSuperclasses);
                for (Class parentClass : allSuperclasses) {
                    classLevelProperties.setProperties(Archaius2TestConfig.this.annotationReader.getPropertiesForAnnotation(parentClass.getAnnotation(TestPropertyOverride.class)));
                }
                classLevelProperties.setProperties(Archaius2TestConfig.this.annotationReader.getPropertiesForAnnotation(description.getTestClass().getAnnotation(TestPropertyOverride.class)));
                methodLevelProperties.setProperties(Archaius2TestConfig.this.annotationReader.getPropertiesForAnnotation((TestPropertyOverride)description.getAnnotation(TestPropertyOverride.class)));
                Archaius2TestConfig.this.testCompositeConfig = new TestCompositeConfig((SettableConfig)runtimeLevelProperties, (SettableConfig)classLevelProperties, (SettableConfig)methodLevelProperties);
                base.evaluate();
            }
        };
    }

    private String getKey(Description description) {
        return description.getClassName() + description.getMethodName() + description.getDisplayName();
    }

    public void addListener(ConfigListener listener) {
        this.testCompositeConfig.addListener(listener);
    }

    public void removeListener(ConfigListener listener) {
        this.testCompositeConfig.removeListener(listener);
    }

    public Object getRawProperty(String key) {
        return this.testCompositeConfig.getRawProperty(key);
    }

    public Long getLong(String key) {
        return this.testCompositeConfig.getLong(key);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.testCompositeConfig.getLong(key, defaultValue);
    }

    public String getString(String key) {
        return this.testCompositeConfig.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.testCompositeConfig.getString(key, defaultValue);
    }

    public Double getDouble(String key) {
        return this.testCompositeConfig.getDouble(key);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.testCompositeConfig.getDouble(key, defaultValue);
    }

    public Integer getInteger(String key) {
        return this.testCompositeConfig.getInteger(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.testCompositeConfig.getInteger(key, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.testCompositeConfig.getBoolean(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.testCompositeConfig.getBoolean(key, defaultValue);
    }

    public Short getShort(String key) {
        return this.testCompositeConfig.getShort(key);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.testCompositeConfig.getShort(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.testCompositeConfig.getBigInteger(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.testCompositeConfig.getBigInteger(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.testCompositeConfig.getBigDecimal(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.testCompositeConfig.getBigDecimal(key, defaultValue);
    }

    public Float getFloat(String key) {
        return this.testCompositeConfig.getFloat(key);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.testCompositeConfig.getFloat(key, defaultValue);
    }

    public Byte getByte(String key) {
        return this.testCompositeConfig.getByte(key);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.testCompositeConfig.getByte(key, defaultValue);
    }

    public List<?> getList(String key) {
        return this.testCompositeConfig.getList(key);
    }

    public <T> List<T> getList(String key, Class<T> type) {
        return this.testCompositeConfig.getList(key, type);
    }

    public List<?> getList(String key, List<?> defaultValue) {
        return this.testCompositeConfig.getList(key, defaultValue);
    }

    public <T> T get(Class<T> type, String key) {
        return (T)this.testCompositeConfig.get(type, key);
    }

    public <T> T get(Class<T> type, String key, T defaultValue) {
        return (T)this.testCompositeConfig.get(type, key, defaultValue);
    }

    public boolean containsKey(String key) {
        return this.testCompositeConfig.containsKey(key);
    }

    public boolean isEmpty() {
        return this.testCompositeConfig.isEmpty();
    }

    public Iterator<String> getKeys() {
        return this.testCompositeConfig.getKeys();
    }

    public Iterator<String> getKeys(String prefix) {
        return this.testCompositeConfig.getKeys(prefix);
    }

    public Config getPrefixedView(String prefix) {
        return this.testCompositeConfig.getPrefixedView(prefix);
    }

    public void setStrInterpolator(StrInterpolator interpolator) {
        this.testCompositeConfig.setStrInterpolator(interpolator);
    }

    public StrInterpolator getStrInterpolator() {
        return this.testCompositeConfig.getStrInterpolator();
    }

    public void setDecoder(Decoder decoder) {
        this.testCompositeConfig.setDecoder(decoder);
    }

    public Decoder getDecoder() {
        return this.testCompositeConfig.getDecoder();
    }

    public <T> T accept(Config.Visitor<T> visitor) {
        return (T)this.testCompositeConfig.accept(visitor);
    }

    public void setProperties(Config config) {
        this.testCompositeConfig.setProperties(config);
    }

    public void setProperties(Properties properties) {
        this.testCompositeConfig.setProperties(properties);
    }

    public <T> void setProperty(String propName, T propValue) {
        this.testCompositeConfig.setProperty(propName, propValue);
    }

    public void clearProperty(String propName) {
        this.testCompositeConfig.clearProperty(propName);
    }

    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.testCompositeConfig.forEachProperty(consumer);
    }
}

