/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.test;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.test.TestConfigException;
import com.netflix.archaius.test.TestPropertyOverride;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ClassUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class Archaius2TestConfig
implements TestRule,
Config {
    private final ThreadLocal<Config> configHolder = new ThreadLocal();

    public Statement apply(Statement base, Description description) {
        return this.statement(base, description);
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    Archaius2TestConfig.this.createConfig(description);
                    base.evaluate();
                }
                finally {
                    Archaius2TestConfig.this.cleanupConfig(description);
                }
            }
        };
    }

    private void createConfig(Description description) {
        Properties props = new Properties();
        for (Class parentClass : ClassUtils.getAllSuperclasses((Class)description.getTestClass())) {
            this.addPropertiesUsingAnnotation(parentClass.getAnnotation(TestPropertyOverride.class), props);
        }
        this.addPropertiesUsingAnnotation(description.getTestClass().getAnnotation(TestPropertyOverride.class), props);
        this.addPropertiesUsingAnnotation((TestPropertyOverride)description.getAnnotation(TestPropertyOverride.class), props);
        this.configHolder.set((Config)new MapConfig(props));
    }

    private void addPropertiesUsingAnnotation(TestPropertyOverride annotation, Properties properties) {
        if (annotation == null) {
            return;
        }
        for (String fileName : annotation.propertyFiles()) {
            try {
                properties.load(this.getClass().getClassLoader().getResourceAsStream(fileName));
            }
            catch (IOException e) {
                throw new TestConfigException("Failed to load property file from classpath", e);
            }
        }
        for (String override : annotation.value()) {
            String[] parts = override.split("=", 2);
            if (parts.length < 2) {
                throw new TestConfigException("Error parsing TestPropertyOverride for: " + annotation.value() + " Please ensure you are specifying overrides in the form \"key=value\"");
            }
            properties.put(parts[0], parts[1]);
        }
    }

    private void cleanupConfig(Description description) {
        this.configHolder.remove();
    }

    private String getKey(Description description) {
        return description.getClassName() + description.getMethodName() + description.getDisplayName();
    }

    public void addListener(ConfigListener listener) {
        this.configHolder.get().addListener(listener);
    }

    public void removeListener(ConfigListener listener) {
        this.configHolder.get().removeListener(listener);
    }

    public Object getRawProperty(String key) {
        return this.configHolder.get().getRawProperty(key);
    }

    public Long getLong(String key) {
        return this.configHolder.get().getLong(key);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.configHolder.get().getLong(key, defaultValue);
    }

    public String getString(String key) {
        return this.configHolder.get().getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.configHolder.get().getString(key, defaultValue);
    }

    public Double getDouble(String key) {
        return this.configHolder.get().getDouble(key);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.configHolder.get().getDouble(key, defaultValue);
    }

    public Integer getInteger(String key) {
        return this.configHolder.get().getInteger(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.configHolder.get().getInteger(key, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.configHolder.get().getBoolean(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.configHolder.get().getBoolean(key, defaultValue);
    }

    public Short getShort(String key) {
        return this.configHolder.get().getShort(key);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.configHolder.get().getShort(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.configHolder.get().getBigInteger(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.configHolder.get().getBigInteger(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.configHolder.get().getBigDecimal(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.configHolder.get().getBigDecimal(key, defaultValue);
    }

    public Float getFloat(String key) {
        return this.configHolder.get().getFloat(key);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.configHolder.get().getFloat(key, defaultValue);
    }

    public Byte getByte(String key) {
        return this.configHolder.get().getByte(key);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.configHolder.get().getByte(key, defaultValue);
    }

    public List<?> getList(String key) {
        return this.configHolder.get().getList(key);
    }

    public <T> List<T> getList(String key, Class<T> type) {
        return this.configHolder.get().getList(key, type);
    }

    public List<?> getList(String key, List<?> defaultValue) {
        return this.configHolder.get().getList(key, defaultValue);
    }

    public <T> T get(Class<T> type, String key) {
        return (T)this.configHolder.get().get(type, key);
    }

    public <T> T get(Class<T> type, String key, T defaultValue) {
        return (T)this.configHolder.get().get(type, key, defaultValue);
    }

    public boolean containsKey(String key) {
        return this.configHolder.get().containsKey(key);
    }

    public boolean isEmpty() {
        return this.configHolder.get().isEmpty();
    }

    public Iterator<String> getKeys() {
        return this.configHolder.get().getKeys();
    }

    public Iterator<String> getKeys(String prefix) {
        return this.configHolder.get().getKeys(prefix);
    }

    public Config getPrefixedView(String prefix) {
        return this.configHolder.get().getPrefixedView(prefix);
    }

    public void setStrInterpolator(StrInterpolator interpolator) {
        this.configHolder.get().setStrInterpolator(interpolator);
    }

    public StrInterpolator getStrInterpolator() {
        return this.configHolder.get().getStrInterpolator();
    }

    public void setDecoder(Decoder decoder) {
        this.configHolder.get().setDecoder(decoder);
    }

    public Decoder getDecoder() {
        return this.configHolder.get().getDecoder();
    }

    public <T> T accept(Config.Visitor<T> visitor) {
        return (T)this.configHolder.get().accept(visitor);
    }
}

