/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.persisted2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.archaius.config.polling.PollingResponse;
import com.netflix.archaius.persisted2.ScopePredicate;
import com.netflix.archaius.persisted2.ScopePredicates;
import com.netflix.archaius.persisted2.ScopePriorityPropertyValueResolver;
import com.netflix.archaius.persisted2.ScopedValue;
import com.netflix.archaius.persisted2.ScopedValueResolver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPersistedV2Reader
implements Callable<PollingResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPersistedV2Reader.class);
    private static final List<String> DEFAULT_ORDERED_SCOPES = Arrays.asList("serverId", "asg", "ami", "cluster", "appId", "env", "countries", "stack", "zone", "region");
    private static final String DEFAULT_KEY_FIELD = "key";
    private static final String DEFAULT_VALUE_FIELD = "value";
    private static final List<String> DEFAULT_PATH = Arrays.asList("persistedproperties", "properties", "property");
    private final Callable<InputStream> reader;
    private final ScopePredicate predicate;
    private final ScopedValueResolver valueResolver;
    private final ObjectMapper mapper = new ObjectMapper();
    private final List<String> scopeFields;
    private final String keyField;
    private final String valueField;
    private final List<String> path;

    public static Builder builder(Callable<InputStream> reader) {
        return new Builder(reader);
    }

    private JsonPersistedV2Reader(Builder builder) {
        this.reader = builder.reader;
        this.predicate = builder.predicate;
        this.valueResolver = builder.resolver;
        this.keyField = builder.keyField;
        this.valueField = builder.valueField;
        this.scopeFields = builder.scopeFields;
        this.path = builder.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollingResponse call() throws Exception {
        HashMap<String, ArrayList<ScopedValue>> props = new HashMap<String, ArrayList<ScopedValue>>();
        InputStream is = this.reader.call();
        if (is == null) {
            return PollingResponse.noop();
        }
        try {
            JsonNode node = this.mapper.readTree(is);
            for (String part : this.path) {
                node = node.path(part);
            }
            for (JsonNode property : node) {
                String key = null;
                try {
                    key = property.get(this.keyField).asText();
                    String value = property.has(this.valueField) ? property.get(this.valueField).asText() : "";
                    LinkedHashMap<String, Set<String>> scopes = new LinkedHashMap<String, Set<String>>();
                    for (String scope : this.scopeFields) {
                        String[] values = StringUtils.splitByWholeSeparator((String)(property.has(scope) ? property.get(scope).asText().toLowerCase() : ""), (String)",");
                        scopes.put(scope, values.length == 0 ? Collections.emptySet() : JsonPersistedV2Reader.immutableSetFrom(values));
                    }
                    if (!this.predicate.evaluate(scopes)) continue;
                    ArrayList<ScopedValue> variations = (ArrayList<ScopedValue>)props.get(key);
                    if (variations == null) {
                        variations = new ArrayList<ScopedValue>();
                        props.put(key, variations);
                    }
                    variations.add(new ScopedValue(value, scopes));
                }
                catch (Exception e) {
                    LOG.warn("Unable to process property '{}'", (Object)key);
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception node) {}
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : props.entrySet()) {
            result.put(entry.getKey(), this.valueResolver.resolve((String)entry.getKey(), (List)entry.getValue()));
        }
        return PollingResponse.forSnapshot(result);
    }

    private static Set<String> immutableSetFrom(String[] values) {
        if (values.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(values));
        return Collections.unmodifiableSet(set);
    }

    static /* synthetic */ List access$000() {
        return DEFAULT_PATH;
    }

    static /* synthetic */ List access$100() {
        return DEFAULT_ORDERED_SCOPES;
    }

    public static class Builder {
        private final Callable<InputStream> reader;
        private List<String> path = JsonPersistedV2Reader.access$000();
        private List<String> scopeFields = JsonPersistedV2Reader.access$100();
        private String keyField = "key";
        private String valueField = "value";
        private ScopePredicate predicate = ScopePredicates.alwaysTrue();
        private ScopedValueResolver resolver = new ScopePriorityPropertyValueResolver();

        public Builder(Callable<InputStream> reader) {
            this.reader = reader;
        }

        public Builder withPath(String path) {
            return this.withPath(Arrays.asList(StringUtils.split((String)path, (String)"/")));
        }

        public Builder withPath(List<String> path) {
            ArrayList<String> copy = new ArrayList<String>();
            copy.addAll(path);
            this.path = Collections.unmodifiableList(copy);
            return this;
        }

        public Builder withScopes(List<String> scopes) {
            this.scopeFields = scopes;
            return this;
        }

        public Builder withPredicate(ScopePredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder withKeyField(String keyField) {
            this.keyField = keyField;
            return this;
        }

        public Builder withValueField(String valueField) {
            this.valueField = valueField;
            return this;
        }

        public Builder withValueResolver(ScopedValueResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public JsonPersistedV2Reader build() {
            return new JsonPersistedV2Reader(this);
        }
    }
}

