/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.persisted2;

import com.netflix.archaius.persisted2.Persisted2ClientConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultPersisted2ClientConfig
implements Persisted2ClientConfig {
    private int refreshRate = 30;
    private List<String> prioritizedScopes = new ArrayList<String>();
    private Map<String, Set<String>> queryScopes = new HashMap<String, Set<String>>();
    private String serviceUrl;
    private Map<String, String> scopes = new HashMap<String, String>();
    private boolean skipPropsWithExtraScopes = false;
    private boolean isEnabled = true;

    public DefaultPersisted2ClientConfig withRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
        return this;
    }

    @Override
    public int getRefreshRate() {
        return this.refreshRate;
    }

    public DefaultPersisted2ClientConfig withPrioritizedScopes(List<String> scopes) {
        this.prioritizedScopes = scopes;
        return this;
    }

    public DefaultPersisted2ClientConfig withPrioritizedScopes(String ... scopes) {
        this.prioritizedScopes = Arrays.asList(scopes);
        return this;
    }

    @Override
    public List<String> getPrioritizedScopes() {
        return this.prioritizedScopes;
    }

    public DefaultPersisted2ClientConfig withScope(String name, String value) {
        this.scopes.put(name, value);
        return this;
    }

    @Override
    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public DefaultPersisted2ClientConfig withQueryScope(String name, String ... values) {
        HashSet<String> unique = new HashSet<String>();
        unique.addAll(Arrays.asList(values));
        this.queryScopes.put(name, unique);
        return this;
    }

    @Override
    public Map<String, Set<String>> getQueryScopes() {
        return this.queryScopes;
    }

    public DefaultPersisted2ClientConfig withServiceUrl(String url) {
        this.serviceUrl = url;
        return this;
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public DefaultPersisted2ClientConfig withSkipPropsWithExtraScopes(boolean value) {
        this.skipPropsWithExtraScopes = value;
        return this;
    }

    @Override
    public boolean getSkipPropsWithExtraScopes() {
        return this.skipPropsWithExtraScopes;
    }

    public DefaultPersisted2ClientConfig setEnabled(boolean value) {
        this.isEnabled = value;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return "DefaultPersisted2ClientConfig[" + ("url=" + this.serviceUrl) + (" scopes=" + this.scopes) + (" priority=" + this.prioritizedScopes) + (" queryScopes=" + this.queryScopes) + (" enabled=" + this.isEnabled) + "]";
    }
}

