/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.persisted2;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.persisted2.AbstractScopePredicate;
import com.netflix.archaius.persisted2.ScopePredicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ScopePredicates {
    public static ScopePredicate alwaysTrue() {
        return new ScopePredicate(){

            @Override
            public boolean evaluate(Map<String, Set<String>> attrs) {
                return true;
            }
        };
    }

    public static ScopePredicate fromConfig(final Config config) {
        final HashMap lookup = new HashMap();
        return new AbstractScopePredicate(){

            @Override
            public String getScope(String key) {
                String value = (String)lookup.get(key);
                if (value == null) {
                    value = config.getString(key, "");
                    lookup.put(key, value.toLowerCase());
                }
                return value;
            }
        };
    }

    public static ScopePredicate fromMap(Map<String, String> values) {
        final HashMap<String, String> lowerCaseValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            lowerCaseValues.put(entry.getKey(), entry.getValue().toLowerCase());
        }
        return new AbstractScopePredicate(){

            @Override
            public String getScope(String key) {
                String value = (String)lowerCaseValues.get(key);
                return value == null ? "" : value;
            }
        };
    }
}

