/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.persisted2.loader;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;

public class HTTPStreamLoader
implements Callable<InputStream> {
    private String lastEtag;
    private final URL url;

    public HTTPStreamLoader(URL url) {
        this.url = url;
    }

    @Override
    public InputStream call() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        conn.setConnectTimeout(6000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Accept-Encoding", "gzip");
        if (this.lastEtag != null) {
            conn.setRequestProperty("If-None-Match", this.lastEtag);
        }
        conn.connect();
        int status = conn.getResponseCode();
        if (status == 200) {
            this.lastEtag = conn.getHeaderField("ETag");
            InputStream input = conn.getInputStream();
            if ("gzip".equals(conn.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            return input;
        }
        if (status == 304) {
            return null;
        }
        throw new RuntimeException("Failed to read input " + conn.getResponseCode());
    }
}

