/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.persisted2;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.config.PollingStrategy;
import com.netflix.archaius.config.EmptyConfig;
import com.netflix.archaius.config.PollingDynamicConfig;
import com.netflix.archaius.config.polling.FixedPollingStrategy;
import com.netflix.archaius.persisted2.JsonPersistedV2Reader;
import com.netflix.archaius.persisted2.Persisted2ClientConfig;
import com.netflix.archaius.persisted2.ScopePredicates;
import com.netflix.archaius.persisted2.loader.HTTPStreamLoader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persisted2ConfigProvider
implements Provider<Config> {
    private final Logger LOG = LoggerFactory.getLogger(Persisted2ConfigProvider.class);
    private final Provider<Persisted2ClientConfig> config;
    private volatile PollingDynamicConfig dynamicConfig;

    @Inject
    public Persisted2ConfigProvider(Provider<Persisted2ClientConfig> config) throws Exception {
        this.config = config;
    }

    public static String getFilterString(Map<String, Set<String>> scopes) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<String>> scope : scopes.entrySet()) {
            if (scope.getValue().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append("(");
            boolean first = true;
            for (String value : scope.getValue()) {
                if (!first) {
                    sb.append(" or ");
                } else {
                    first = false;
                }
                sb.append(scope.getKey());
                if (null == value) {
                    sb.append(" is null");
                    continue;
                }
                if (value.isEmpty()) {
                    sb.append("=''");
                    continue;
                }
                sb.append("='").append(value).append("'");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public Config get() {
        try {
            Persisted2ClientConfig clientConfig = (Persisted2ClientConfig)this.config.get();
            this.LOG.info("Remote config : " + clientConfig);
            String url = clientConfig.getServiceUrl() + "?skipPropsWithExtraScopes=" + clientConfig.getSkipPropsWithExtraScopes() + "&filter=" + URLEncoder.encode(Persisted2ConfigProvider.getFilterString(clientConfig.getQueryScopes()), "UTF-8");
            if (!clientConfig.isEnabled()) {
                return EmptyConfig.INSTANCE;
            }
            JsonPersistedV2Reader reader = JsonPersistedV2Reader.builder(new HTTPStreamLoader(new URL(url))).withPath("propertiesList").withScopes(clientConfig.getPrioritizedScopes()).withPredicate(ScopePredicates.fromMap(clientConfig.getScopes())).build();
            this.dynamicConfig = new PollingDynamicConfig((Callable)reader, (PollingStrategy)new FixedPollingStrategy((long)clientConfig.getRefreshRate(), TimeUnit.SECONDS));
            return this.dynamicConfig;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.dynamicConfig != null) {
            this.dynamicConfig.shutdown();
        }
    }
}

