/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.util;

import com.netflix.archaius.Internal;
import java.util.HashMap;
import java.util.LinkedHashMap;

@Internal
public final class Maps {
    private Maps() {
    }

    private static int calculateCapacity(int numMappings) {
        return (int)Math.ceil((double)numMappings / 0.75);
    }

    public static <K, V> HashMap<K, V> newHashMap(int numMappings) {
        return new HashMap(Maps.calculateCapacity(numMappings));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int numMappings) {
        return new LinkedHashMap(Maps.calculateCapacity(numMappings));
    }
}

