/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.converters;

import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.exceptions.ParseException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class DefaultTypeConverterFactory
implements TypeConverter.Factory {
    public static final DefaultTypeConverterFactory INSTANCE = new DefaultTypeConverterFactory();
    private final Map<Type, TypeConverter<?>> converters;

    private static Boolean convertBoolean(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        throw new ParseException("Error parsing value '" + value + "'", new Exception("Expected one of [true, yes, on, false, no, off]"));
    }

    private DefaultTypeConverterFactory() {
        HashMap<Class<Serializable>, TypeConverter> converters = new HashMap<Class<Serializable>, TypeConverter>();
        converters.put(String.class, Function.identity()::apply);
        converters.put(Boolean.TYPE, DefaultTypeConverterFactory::convertBoolean);
        converters.put(Boolean.class, DefaultTypeConverterFactory::convertBoolean);
        converters.put(Integer.class, x$0 -> Lenient.parseInt(x$0));
        converters.put(Integer.TYPE, x$0 -> Lenient.parseInt(x$0));
        converters.put(Long.TYPE, x$0 -> Lenient.parseLong(x$0));
        converters.put(Long.class, x$0 -> Lenient.parseLong(x$0));
        converters.put(Short.TYPE, x$0 -> Lenient.parseShort(x$0));
        converters.put(Short.class, x$0 -> Lenient.parseShort(x$0));
        converters.put(Byte.TYPE, x$0 -> Lenient.parseByte(x$0));
        converters.put(Byte.class, x$0 -> Lenient.parseByte(x$0));
        converters.put(Double.TYPE, x$0 -> Lenient.parseDouble(x$0));
        converters.put(Double.class, x$0 -> Lenient.parseDouble(x$0));
        converters.put(Float.TYPE, x$0 -> Float.valueOf(Lenient.parseFloat(x$0)));
        converters.put(Float.class, x$0 -> Float.valueOf(Lenient.parseFloat(x$0)));
        converters.put(BigInteger.class, BigInteger::new);
        converters.put(BigDecimal.class, BigDecimal::new);
        converters.put(AtomicInteger.class, v -> new AtomicInteger(Lenient.parseInt(v)));
        converters.put(AtomicLong.class, v -> new AtomicLong(Lenient.parseLong(v)));
        converters.put(Duration.class, Duration::parse);
        converters.put(Period.class, Period::parse);
        converters.put(LocalDateTime.class, LocalDateTime::parse);
        converters.put(LocalDate.class, LocalDate::parse);
        converters.put(LocalTime.class, LocalTime::parse);
        converters.put(OffsetDateTime.class, OffsetDateTime::parse);
        converters.put(OffsetTime.class, OffsetTime::parse);
        converters.put(ZonedDateTime.class, ZonedDateTime::parse);
        converters.put(Instant.class, v -> Instant.from(OffsetDateTime.parse(v)));
        converters.put(Date.class, v -> new Date(Lenient.parseLong(v)));
        converters.put(Currency.class, Currency::getInstance);
        converters.put(URI.class, URI::create);
        converters.put(Locale.class, Locale::forLanguageTag);
        converters.put(BitSet.class, v -> {
            try {
                return BitSet.valueOf(Hex.decodeHex((String)v));
            }
            catch (DecoderException e) {
                throw new RuntimeException(e);
            }
        });
        this.converters = Collections.unmodifiableMap(converters);
    }

    public Optional<TypeConverter<?>> get(Type type, TypeConverter.Registry registry) {
        Objects.requireNonNull(type, "type == null");
        Objects.requireNonNull(registry, "registry == null");
        for (Map.Entry<Type, TypeConverter<?>> entry : this.converters.entrySet()) {
            if (!entry.getKey().equals(type)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private static final class Lenient {
        private Lenient() {
        }

        private static String maybeTrim(String s) {
            return s != null ? s.trim() : null;
        }

        private static long parseLong(String s) throws NumberFormatException {
            if ((s = Lenient.maybeTrim(s)) != null && (s.endsWith("L") || s.endsWith("l"))) {
                s = s.substring(0, s.length() - 1);
            }
            return Long.parseLong(s);
        }

        private static int parseInt(String s) throws NumberFormatException {
            return Integer.parseInt(Lenient.maybeTrim(s));
        }

        private static short parseShort(String s) throws NumberFormatException {
            return Short.parseShort(Lenient.maybeTrim(s));
        }

        private static byte parseByte(String s) throws NumberFormatException {
            return Byte.parseByte(Lenient.maybeTrim(s));
        }

        private static double parseDouble(String s) throws NumberFormatException {
            return Double.parseDouble(Lenient.maybeTrim(s));
        }

        private static float parseFloat(String s) throws NumberFormatException {
            return Float.parseFloat(Lenient.maybeTrim(s));
        }
    }
}

