/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.PropertyDetails;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.CachedState;
import java.util.Iterator;
import java.util.function.BiConsumer;

public abstract class AbstractDependentConfig
extends AbstractConfig {
    public AbstractDependentConfig(String name) {
        super(name);
    }

    public AbstractDependentConfig() {
    }

    abstract CachedState getState();

    public Object getRawProperty(String key) {
        CachedState state = this.getState();
        Object value = state.getData().get(key);
        Config config = state.getInstrumentedKeys().get(key);
        if (config != null) {
            config.recordUsage(this.createPropertyDetails(key, value));
        }
        return value;
    }

    public Object getRawPropertyUninstrumented(String key) {
        return this.getState().getData().get(key);
    }

    public Iterator<String> getKeys() {
        return this.getState().getData().keySet().iterator();
    }

    public Iterable<String> keys() {
        return this.getState().getData().keySet();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        CachedState state = this.getState();
        state.getData().forEach((k, v) -> {
            Config config = state.getInstrumentedKeys().get(k);
            if (config != null) {
                config.recordUsage(this.createPropertyDetails((String)k, v));
            }
            consumer.accept((String)k, v);
        });
    }

    public void forEachPropertyUninstrumented(BiConsumer<String, Object> consumer) {
        this.getState().getData().forEach(consumer);
    }

    public boolean containsKey(String key) {
        return this.getState().getData().containsKey(key);
    }

    public boolean isEmpty() {
        return this.getState().getData().isEmpty();
    }

    public void recordUsage(PropertyDetails propertyDetails) {
        CachedState state = this.getState();
        Config config = state.getInstrumentedKeys().get(propertyDetails.getKey());
        if (config != null) {
            config.recordUsage(this.createPropertyDetails(propertyDetails.getKey(), propertyDetails.getValue()));
        }
    }

    public boolean instrumentationEnabled() {
        return !this.getState().getInstrumentedKeys().isEmpty();
    }

    protected PropertyDetails createPropertyDetails(String key, Object value) {
        return new PropertyDetails(key, null, value);
    }
}

