/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyContainer;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.PropertyListener;
import com.netflix.archaius.exceptions.ParseException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyFactory
implements PropertyFactory,
ConfigListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPropertyFactory.class);
    private static final AtomicReferenceFieldUpdater<PropertyImpl, CachedValue> CACHED_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PropertyImpl.class, CachedValue.class, "cachedValue");
    private final Config config;
    private final ConcurrentMap<KeyAndType<?>, Property<?>> properties = new ConcurrentHashMap();
    private final AtomicInteger masterVersion = new AtomicInteger();
    private final List<Runnable> listeners = new CopyOnWriteArrayList<Runnable>();

    public static DefaultPropertyFactory from(Config config) {
        return new DefaultPropertyFactory(config);
    }

    public DefaultPropertyFactory(Config config) {
        this.config = config;
        this.config.addListener((ConfigListener)this);
    }

    @Deprecated
    public PropertyContainer getProperty(String propName) {
        return new PropertyContainerImpl(propName);
    }

    public void onConfigAdded(Config config) {
        this.invalidate();
    }

    public void onConfigRemoved(Config config) {
        this.invalidate();
    }

    public void onConfigUpdated(Config config) {
        this.invalidate();
    }

    public void onError(Throwable error, Config config) {
    }

    public void invalidate() {
        this.masterVersion.incrementAndGet();
        this.listeners.forEach(Runnable::run);
    }

    protected Config getConfig() {
        return this.config;
    }

    public <T> Property<T> get(String key, Class<T> type) {
        return this.getFromSupplier(key, type, () -> this.config.get(type, key, null));
    }

    public <T> Property<T> get(String key, Type type) {
        return this.getFromSupplier(key, type, () -> this.config.get(type, key, null));
    }

    private <T> Property<T> getFromSupplier(String key, Type type, Supplier<T> supplier) {
        return this.getFromSupplier(new KeyAndType(key, type), supplier);
    }

    private <T> Property<T> getFromSupplier(KeyAndType<T> keyAndType, Supplier<T> supplier) {
        return this.properties.computeIfAbsent(keyAndType, ignore -> new PropertyImpl(keyAndType, supplier));
    }

    private final class PropertyContainerImpl
    implements PropertyContainer {
        private final String propName;

        public PropertyContainerImpl(String propName) {
            this.propName = propName;
        }

        public Property<String> asString(String defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, String.class).orElse((Object)defaultValue);
        }

        public Property<Integer> asInteger(Integer defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, Integer.class).orElse((Object)defaultValue);
        }

        public Property<Long> asLong(Long defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, Long.class).orElse((Object)defaultValue);
        }

        public Property<Double> asDouble(Double defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, Double.class).orElse((Object)defaultValue);
        }

        public Property<Float> asFloat(Float defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, Float.class).orElse((Object)defaultValue);
        }

        public Property<Short> asShort(Short defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, Short.class).orElse((Object)defaultValue);
        }

        public Property<Byte> asByte(Byte defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, Byte.class).orElse((Object)defaultValue);
        }

        public Property<Boolean> asBoolean(Boolean defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, Boolean.class).orElse((Object)defaultValue);
        }

        public Property<BigDecimal> asBigDecimal(BigDecimal defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, BigDecimal.class).orElse((Object)defaultValue);
        }

        public Property<BigInteger> asBigInteger(BigInteger defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, BigInteger.class).orElse((Object)defaultValue);
        }

        public <T> Property<T> asType(Class<T> type, T defaultValue) {
            return DefaultPropertyFactory.this.get(this.propName, type).orElse(defaultValue);
        }

        public <T> Property<T> asType(Function<String, T> mapper, String defaultValue) {
            Object typedDefaultValue = this.applyOrThrow(mapper, defaultValue);
            return DefaultPropertyFactory.this.getFromSupplier(this.propName, null, () -> {
                String stringValue = DefaultPropertyFactory.this.config.getString(this.propName, null);
                try {
                    return stringValue != null ? this.applyOrThrow(mapper, stringValue) : typedDefaultValue;
                }
                catch (ParseException pe) {
                    LOG.error("Error parsing value '{}' for property '{}'", new Object[]{stringValue, this.propName, pe});
                    return typedDefaultValue;
                }
            });
        }

        private <T> T applyOrThrow(Function<String, T> mapper, String value) {
            try {
                return mapper.apply(value);
            }
            catch (RuntimeException e) {
                throw new ParseException("Invalid value '" + value + "' for property '" + this.propName + "'.", e);
            }
        }

        public String toString() {
            return "PropertyContainer [name=" + this.propName + "]";
        }
    }

    private static final class CachedValue<T> {
        final T value;
        final int version;

        CachedValue(T value, int version) {
            this.value = value;
            this.version = version;
        }

        public String toString() {
            return "CachedValue{value=" + this.value + ", version=" + this.version + '}';
        }
    }

    private static final class KeyAndType<T> {
        private final String key;
        private final Type type;

        public KeyAndType(String key, Type type) {
            this.key = key;
            this.type = type;
        }

        public <S> KeyAndType<S> discardType() {
            if (this.type == null) {
                KeyAndType keyAndType = this;
                return keyAndType;
            }
            return new KeyAndType<T>(this.key, null);
        }

        public KeyAndType<T> withKey(String newKey) {
            return new KeyAndType<T>(newKey, this.type);
        }

        public boolean hasType() {
            return this.type != null;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.key);
            result = 31 * result + Objects.hashCode(this.type);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeyAndType)) {
                return false;
            }
            KeyAndType other = (KeyAndType)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.type, other.type);
        }

        public String toString() {
            return "KeyAndType{key='" + this.key + '\'' + ", type=" + this.type + '}';
        }
    }

    private final class PropertyImpl<T>
    implements Property<T> {
        private final KeyAndType<T> keyAndType;
        private final Supplier<T> supplier;
        volatile CachedValue<T> cachedValue;
        private Map<PropertyListener<?>, Property.Subscription> oldSubscriptions;

        public PropertyImpl(KeyAndType<T> keyAndType, Supplier<T> supplier) {
            this.keyAndType = keyAndType;
            this.supplier = supplier;
        }

        public T get() {
            CachedValue<T> newValue;
            int currentMasterVersion = DefaultPropertyFactory.this.masterVersion.get();
            CachedValue<T> currentCachedValue = this.cachedValue;
            if (currentCachedValue != null && currentCachedValue.version >= currentMasterVersion) {
                return currentCachedValue.value;
            }
            try {
                newValue = new CachedValue<T>(this.supplier.get(), currentMasterVersion);
            }
            catch (RuntimeException e) {
                LOG.error("Unable to update value for property '{}'", (Object)((KeyAndType)this.keyAndType).key, (Object)e);
                return null;
            }
            CACHED_VALUE_UPDATER.compareAndSet(this, currentCachedValue, newValue);
            return newValue.value;
        }

        public String getKey() {
            return ((KeyAndType)this.keyAndType).key;
        }

        public Property.Subscription subscribe(final Consumer<T> consumer) {
            Runnable action = new Runnable(){
                private T current;
                {
                    this.current = PropertyImpl.this.get();
                }

                @Override
                public synchronized void run() {
                    try {
                        Object newValue = PropertyImpl.this.get();
                        if (this.current == newValue && this.current == null) {
                            return;
                        }
                        if (this.current == null) {
                            this.current = newValue;
                        } else if (newValue == null) {
                            this.current = null;
                        } else {
                            if (this.current.equals(newValue)) {
                                return;
                            }
                            this.current = newValue;
                        }
                        consumer.accept(this.current);
                    }
                    catch (RuntimeException e) {
                        LOG.error("Unable to notify subscriber about update to property '{}'. Subscriber: {}", new Object[]{PropertyImpl.this.keyAndType, consumer, e});
                    }
                }
            };
            DefaultPropertyFactory.this.listeners.add(action);
            return () -> DefaultPropertyFactory.this.listeners.remove(action);
        }

        @Deprecated
        public synchronized void addListener(PropertyListener<T> listener) {
            if (this.oldSubscriptions == null) {
                this.oldSubscriptions = new HashMap();
            }
            this.oldSubscriptions.put(listener, this.subscribe((Consumer<T>)listener));
        }

        @Deprecated
        public synchronized void removeListener(PropertyListener<T> listener) {
            if (this.oldSubscriptions == null) {
                return;
            }
            Property.Subscription subscription = this.oldSubscriptions.remove(listener);
            if (subscription != null) {
                subscription.unsubscribe();
            }
        }

        public Property<T> orElse(T defaultValue) {
            return new PropertyImpl<Object>(this.keyAndType, () -> {
                T value = this.get();
                return value != null ? value : defaultValue;
            });
        }

        public Property<T> orElseGet(String key) {
            if (!this.keyAndType.hasType()) {
                throw new IllegalStateException("Type information lost due to map() operation.  All calls to orElseGet() must be made prior to calling map");
            }
            KeyAndType<T> keyAndType = this.keyAndType.withKey(key);
            Property next = DefaultPropertyFactory.this.get(key, ((KeyAndType)keyAndType).type);
            return new PropertyImpl<Object>(keyAndType, () -> {
                T value = this.get();
                return value != null ? value : next.get();
            });
        }

        public <S> Property<S> map(Function<T, S> mapper) {
            return new PropertyImpl<Object>(this.keyAndType.discardType(), () -> {
                T value = this.get();
                if (value != null) {
                    return mapper.apply(value);
                }
                return null;
            });
        }

        public String toString() {
            return "Property [Key=" + this.keyAndType + "; cachedValue=" + this.cachedValue + "]";
        }
    }
}

