/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.IoCContainer;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.exceptions.MappingException;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.text.StrSubstitutor;

public class ConfigMapper {
    private static final IoCContainer NULL_IOC_CONTAINER = new IoCContainer(){

        public <T> T getInstance(String name, Class<T> type) {
            return null;
        }
    };

    public <T> void mapConfig(T injectee, Config config) throws MappingException {
        this.mapConfig(injectee, config, NULL_IOC_CONTAINER);
    }

    /*
     * WARNING - void declaration
     */
    public <T> void mapConfig(T injectee, Config config, IoCContainer ioc) throws MappingException {
        String objName;
        Object value;
        Class<?> type;
        String name;
        Configuration configAnnot = injectee.getClass().getAnnotation(Configuration.class);
        if (configAnnot == null) {
            return;
        }
        Class<?> injecteeType = injectee.getClass();
        String prefix = configAnnot.prefix();
        String[] params = configAnnot.params();
        if (params.length > 0) {
            void var11_15;
            AccessibleObject[] map = new HashMap();
            String[] stringArray = params;
            int n = stringArray.length;
            boolean i = false;
            while (var11_15 < n) {
                String param = stringArray[var11_15];
                try {
                    Field f = injecteeType.getDeclaredField(param);
                    f.setAccessible(true);
                    map.put(param, f.get(injectee).toString());
                }
                catch (NoSuchFieldException e) {
                    try {
                        Method method = injecteeType.getDeclaredMethod("get" + Character.toUpperCase(param.charAt(0)) + param.substring(1), new Class[0]);
                        method.setAccessible(true);
                        map.put(param, method.invoke(injectee, new Object[0]).toString());
                    }
                    catch (Exception e1) {
                        throw new MappingException(e1);
                    }
                }
                catch (Exception e) {
                    throw new MappingException(e);
                }
                ++var11_15;
            }
            prefix = StrSubstitutor.replace((Object)prefix, (Map)map, (String)"${", (String)"}");
        }
        if (!(prefix = config.getStrInterpolator().create(ConfigStrLookup.from(config)).resolve(prefix)).isEmpty() && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (configAnnot.allowFields()) {
            for (AccessibleObject accessibleObject : injecteeType.getDeclaredFields()) {
                if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                name = ((Field)accessibleObject).getName();
                type = ((Field)accessibleObject).getType();
                value = null;
                if (type.isInterface()) {
                    objName = config.getString(prefix + name, null);
                    if (objName != null) {
                        value = ioc.getInstance(objName, type);
                    }
                } else {
                    value = config.get(type, prefix + name, null);
                }
                if (value == null) continue;
                try {
                    ((Field)accessibleObject).setAccessible(true);
                    ((Field)accessibleObject).set(injectee, value);
                }
                catch (Exception e) {
                    throw new MappingException("Unable to inject field " + injectee.getClass() + "." + name + " with value " + value, e);
                }
            }
        }
        if (configAnnot.allowSetters()) {
            for (AccessibleObject accessibleObject : injectee.getClass().getDeclaredMethods()) {
                if (((Method)accessibleObject).getParameterCount() != 1) continue;
                name = ((Method)accessibleObject).getName();
                if (name.startsWith("set") && name.length() > 3) {
                    name = name.substring(3, 4).toLowerCase() + name.substring(4);
                } else {
                    if (!name.startsWith("with") || name.length() <= 4) continue;
                    name = name.substring(4, 1).toLowerCase() + name.substring(5);
                }
                ((Method)accessibleObject).setAccessible(true);
                type = ((Method)accessibleObject).getParameterTypes()[0];
                value = null;
                if (type.isInterface()) {
                    objName = config.getString(prefix + name, null);
                    if (objName != null) {
                        value = ioc.getInstance(objName, type);
                    }
                } else {
                    value = config.get(type, prefix + name, null);
                }
                if (value == null) continue;
                try {
                    ((Method)accessibleObject).invoke(injectee, value);
                }
                catch (Exception e) {
                    throw new MappingException("Unable to inject field " + injectee.getClass() + "." + name + " with value " + value, e);
                }
            }
        }
        if (!configAnnot.postConfigure().isEmpty()) {
            try {
                Method m = injecteeType.getMethod(configAnnot.postConfigure(), new Class[0]);
                m.invoke(injectee, new Object[0]);
            }
            catch (Exception e) {
                throw new MappingException("Unable to invoke postConfigure method " + configAnnot.postConfigure(), e);
            }
        }
    }
}

