/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.converters;

import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.exceptions.ConverterNotFoundException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;

public final class DefaultCollectionsTypeConverterFactory
implements TypeConverter.Factory {
    public static final DefaultCollectionsTypeConverterFactory INSTANCE = new DefaultCollectionsTypeConverterFactory();

    private DefaultCollectionsTypeConverterFactory() {
    }

    public Optional<TypeConverter<?>> get(Type type, TypeConverter.Registry registry) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType().equals(Map.class)) {
                return Optional.of(DefaultCollectionsTypeConverterFactory.createMapTypeConverter((TypeConverter)registry.get(parameterizedType.getActualTypeArguments()[0]).orElseThrow(() -> new ConverterNotFoundException("No converter found")), (TypeConverter)registry.get(parameterizedType.getActualTypeArguments()[1]).orElseThrow(() -> new ConverterNotFoundException("No converter found")), LinkedHashMap::new));
            }
            if (parameterizedType.getRawType().equals(Set.class)) {
                return Optional.of(DefaultCollectionsTypeConverterFactory.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, LinkedHashSet::new, Collections::emptySet, Collections::unmodifiableSet));
            }
            if (parameterizedType.getRawType().equals(SortedSet.class)) {
                return Optional.of(DefaultCollectionsTypeConverterFactory.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, TreeSet::new, Collections::emptySortedSet, Collections::unmodifiableSortedSet));
            }
            if (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Collection.class)) {
                return Optional.of(DefaultCollectionsTypeConverterFactory.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, ArrayList::new, Collections::emptyList, Collections::unmodifiableList));
            }
            if (parameterizedType.getRawType().equals(LinkedList.class)) {
                return Optional.of(DefaultCollectionsTypeConverterFactory.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, LinkedList::new, LinkedList::new, Function.identity()));
            }
        }
        return Optional.empty();
    }

    private static <E, T extends Collection<E>> TypeConverter<T> createCollectionTypeConverter(Type elementType, TypeConverter.Registry registry, Supplier<T> collectionFactory, Supplier<T> emptyCollectionFactory, Function<T, T> finisher) {
        TypeConverter elementConverter = (TypeConverter)registry.get(elementType).orElseThrow(() -> new ConverterNotFoundException("No converter found"));
        boolean ignoreEmpty = !String.class.equals((Object)elementType);
        return value -> {
            if (value.isEmpty()) {
                return (Collection)emptyCollectionFactory.get();
            }
            Collection collection = (Collection)collectionFactory.get();
            for (String item : value.split("\\s*,\\s*")) {
                if (item.isEmpty() && ignoreEmpty) continue;
                collection.add(elementConverter.convert(item));
            }
            return (Collection)finisher.apply(collection);
        };
    }

    private static <K, V> TypeConverter<Map<K, V>> createMapTypeConverter(TypeConverter<K> keyConverter, TypeConverter<V> valueConverter, Supplier<Map<K, V>> mapFactory) {
        return s -> {
            if (s.isEmpty()) {
                return Collections.emptyMap();
            }
            Map result = (Map)mapFactory.get();
            Arrays.stream(s.split("\\s*,\\s*")).filter(pair -> !pair.isEmpty()).map(pair -> pair.split("\\s*=\\s*")).forEach(kv -> result.put(keyConverter.convert(kv[0]), valueConverter.convert(kv[1])));
            return Collections.unmodifiableMap(result);
        };
    }
}

