/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.converters;

import com.netflix.archaius.api.TypeConverter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.ObjIntConsumer;

public final class ArrayTypeConverterFactory
implements TypeConverter.Factory {
    public static final ArrayTypeConverterFactory INSTANCE = new ArrayTypeConverterFactory();

    private ArrayTypeConverterFactory() {
    }

    public Optional<TypeConverter<?>> get(Type type, TypeConverter.Registry registry) {
        if (type instanceof Class && ((Class)type).isArray()) {
            Class clsType = (Class)type;
            Class<?> elementType = clsType.getComponentType();
            TypeConverter elementConverter = (TypeConverter)registry.get(elementType).orElseThrow(() -> new RuntimeException("No converter found for array element type '" + elementType + "'"));
            return Optional.of(ArrayTypeConverterFactory.create((TypeConverter<Object>)elementConverter, clsType.getComponentType()));
        }
        return Optional.empty();
    }

    private static TypeConverter<?> create(TypeConverter<Object> elementConverter, Class<?> type) {
        return value -> {
            ObjIntConsumer<String> elementHandler;
            if ((value = value.trim()).isEmpty()) {
                return Array.newInstance(type, 0);
            }
            String[] elements = value.split(",");
            Object resultArray = Array.newInstance(type, elements.length);
            if (type.isPrimitive()) {
                if (type.equals(Integer.TYPE)) {
                    elementHandler = (s, idx) -> Array.setInt(resultArray, idx, (Integer)elementConverter.convert(s));
                } else if (type.equals(Long.TYPE)) {
                    elementHandler = (s, idx) -> Array.setLong(resultArray, idx, (Long)elementConverter.convert(s));
                } else if (type.equals(Short.TYPE)) {
                    elementHandler = (s, idx) -> Array.setShort(resultArray, idx, (Short)elementConverter.convert(s));
                } else if (type.equals(Byte.TYPE)) {
                    elementHandler = (s, idx) -> Array.setByte(resultArray, idx, (Byte)elementConverter.convert(s));
                } else if (type.equals(Character.TYPE)) {
                    elementHandler = (s, idx) -> Array.setChar(resultArray, idx, ((Character)elementConverter.convert(s)).charValue());
                } else if (type.equals(Boolean.TYPE)) {
                    elementHandler = (s, idx) -> Array.setBoolean(resultArray, idx, (Boolean)elementConverter.convert(s));
                } else if (type.equals(Float.TYPE)) {
                    elementHandler = (s, idx) -> Array.setFloat(resultArray, idx, ((Float)elementConverter.convert(s)).floatValue());
                } else {
                    if (!type.equals(Double.TYPE)) throw new UnsupportedOperationException("Unknown primitive type: " + type);
                    elementHandler = (s, idx) -> Array.setDouble(resultArray, idx, (Double)elementConverter.convert(s));
                }
            } else {
                elementHandler = (s, idx) -> Array.set(resultArray, idx, elementConverter.convert(s));
            }
            for (int i = 0; i < elements.length; ++i) {
                elementHandler.accept(elements[i], i);
            }
            return resultArray;
        };
    }
}

