/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.config.AbstractDependentConfig;
import com.netflix.archaius.config.CachedState;
import com.netflix.archaius.config.DependentConfigListener;
import java.util.LinkedHashMap;
import java.util.Map;

public class PrivateViewConfig
extends AbstractDependentConfig {
    private volatile CachedState state;

    private void updateState(Config config) {
        this.state = this.createState(config);
    }

    private CachedState createState(Config config) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Config> instrumentedKeys = new LinkedHashMap<String, Config>();
        boolean instrumented = config.instrumentationEnabled();
        config.forEachPropertyUninstrumented((k, v) -> {
            data.put((String)k, v);
            if (instrumented) {
                instrumentedKeys.put((String)k, config);
            }
        });
        return new CachedState(data, instrumentedKeys);
    }

    @Override
    public CachedState getState() {
        return this.state;
    }

    public PrivateViewConfig(Config wrappedConfig) {
        this.state = this.createState(wrappedConfig);
        wrappedConfig.addListener((ConfigListener)new ViewConfigListener(this));
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        Object t = null;
        for (Map.Entry<String, Object> entry : this.state.getData().entrySet()) {
            t = visitor.visitKey(entry.getKey(), entry.getValue());
        }
        return (T)t;
    }

    private static class ViewConfigListener
    extends DependentConfigListener<PrivateViewConfig> {
        private ViewConfigListener(PrivateViewConfig dependentConfig) {
            super(dependentConfig);
        }

        @Override
        public void onSourceConfigAdded(PrivateViewConfig pvc, Config config) {
            pvc.updateState(config);
            pvc.notifyConfigAdded(pvc);
        }

        @Override
        public void onSourceConfigRemoved(PrivateViewConfig pvc, Config config) {
            pvc.updateState(config);
            pvc.notifyConfigRemoved(pvc);
        }

        @Override
        public void onSourceConfigUpdated(PrivateViewConfig pvc, Config config) {
            pvc.updateState(config);
            pvc.notifyConfigUpdated(pvc);
        }

        @Override
        public void onSourceError(Throwable error, PrivateViewConfig pvc, Config config) {
        }
    }
}

