/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.config.AbstractConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class MapConfig
extends AbstractConfig {
    private final Map<String, String> props;

    public static Builder builder() {
        return new Builder();
    }

    public static MapConfig from(Properties props) {
        return new MapConfig(props);
    }

    public static MapConfig from(Map<String, String> props) {
        return new MapConfig(props);
    }

    public MapConfig(String name, Map<String, String> props) {
        super(name);
        this.props = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public MapConfig(Map<String, String> props) {
        super(MapConfig.generateUniqueName("immutable-"));
        this.props = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public MapConfig(Properties props) {
        super(MapConfig.generateUniqueName("immutable-"));
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.props = Collections.unmodifiableMap(properties);
    }

    public Object getRawProperty(String key) {
        return this.props.get(key);
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    public Iterable<String> keys() {
        return this.props.keySet();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.props.forEach(consumer);
    }

    public static class Builder {
        Map<String, String> map = new HashMap<String, String>();
        String named;

        public <T> Builder put(String key, T value) {
            this.map.put(key, value.toString());
            return this;
        }

        public <T> Builder putAll(Map<String, String> props) {
            this.map.putAll(props);
            return this;
        }

        public <T> Builder putAll(Properties props) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.map.put(k.toString(), v.toString())));
            return this;
        }

        public Builder name(String name) {
            this.named = name;
            return this;
        }

        public MapConfig build() {
            return new MapConfig(this.named == null ? AbstractConfig.generateUniqueName("immutable-") : this.named, this.map);
        }
    }
}

