/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.AbstractDependentConfig;
import com.netflix.archaius.config.CachedState;
import com.netflix.archaius.config.DependentConfigListener;
import com.netflix.archaius.util.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompositeConfig
extends AbstractDependentConfig
implements CompositeConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompositeConfig.class);
    private final ConfigListener listener;
    private final boolean reversed;
    private volatile State state;

    public static Builder builder() {
        return new Builder();
    }

    public static CompositeConfig create() throws ConfigException {
        return DefaultCompositeConfig.builder().build();
    }

    public DefaultCompositeConfig() {
        this(false);
    }

    public DefaultCompositeConfig(boolean reversed) {
        this.reversed = reversed;
        this.listener = new CompositeConfigListener(this);
        this.state = new State(Collections.emptyMap(), 0);
    }

    @Override
    CachedState getState() {
        return this.state.cachedState;
    }

    private void refreshState() {
        this.state = this.state.refresh();
    }

    public synchronized boolean addConfig(String name, Config child) throws ConfigException {
        return this.internalAddConfig(name, child);
    }

    private synchronized boolean internalAddConfig(String name, Config child) throws ConfigException {
        LOG.info("Adding config {} to {}", (Object)name, (Object)this.hashCode());
        if (child == null) {
            return false;
        }
        if (name == null) {
            throw new ConfigException("Child configuration must be named");
        }
        if (this.state.containsConfig(name)) {
            LOG.info("Configuration with name'{}' already exists", (Object)name);
            return false;
        }
        this.state = this.state.addConfig(name, child);
        this.postConfigAdded(child);
        return true;
    }

    public synchronized void addConfigs(LinkedHashMap<String, Config> configs) throws ConfigException {
        for (Map.Entry<String, Config> entry : configs.entrySet()) {
            this.internalAddConfig(entry.getKey(), entry.getValue());
        }
    }

    public void replaceConfigs(LinkedHashMap<String, Config> configs) throws ConfigException {
        for (Map.Entry<String, Config> entry : configs.entrySet()) {
            this.replaceConfig(entry.getKey(), entry.getValue());
        }
    }

    public synchronized Collection<String> getConfigNames() {
        return this.state.children.keySet();
    }

    protected void postConfigAdded(Config child) {
        child.setStrInterpolator(this.getStrInterpolator());
        child.setDecoder(this.getDecoder());
        this.notifyConfigAdded(child);
        child.addListener(this.listener);
    }

    public synchronized void replaceConfig(String name, Config child) throws ConfigException {
        this.internalRemoveConfig(name);
        this.internalAddConfig(name, child);
    }

    public synchronized Config removeConfig(String name) {
        return this.internalRemoveConfig(name);
    }

    public synchronized Config internalRemoveConfig(String name) {
        Config child = this.state.getConfig(name);
        if (child != null) {
            this.state = this.state.removeConfig(name);
            child.removeListener(this.listener);
            this.notifyConfigRemoved(child);
        }
        return child;
    }

    public Config getConfig(String name) {
        return (Config)this.state.children.get(name);
    }

    @Override
    public synchronized <T> T accept(Config.Visitor<T> visitor) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        if (visitor instanceof CompositeConfig.CompositeVisitor) {
            CompositeConfig.CompositeVisitor cv = (CompositeConfig.CompositeVisitor)visitor;
            this.state.children.forEach((key, config) -> result.set(cv.visitChild(key, config)));
        } else {
            this.state.cachedState.getData().forEach((arg_0, arg_1) -> visitor.visitKey(arg_0, arg_1));
        }
        return result.get();
    }

    public static CompositeConfig from(LinkedHashMap<String, Config> load) throws ConfigException {
        Builder builder = DefaultCompositeConfig.builder();
        for (Map.Entry<String, Config> config : load.entrySet()) {
            builder.withConfig(config.getKey(), config.getValue());
        }
        return builder.build();
    }

    public String toString() {
        return "[" + String.join((CharSequence)" ", this.state.children.keySet()) + "]";
    }

    private static class CompositeConfigListener
    extends DependentConfigListener<DefaultCompositeConfig> {
        private CompositeConfigListener(DefaultCompositeConfig config) {
            super(config);
        }

        @Override
        public void onSourceConfigAdded(DefaultCompositeConfig dcc, Config config) {
            dcc.refreshState();
            dcc.notifyConfigAdded(dcc);
        }

        @Override
        public void onSourceConfigRemoved(DefaultCompositeConfig dcc, Config config) {
            dcc.refreshState();
            dcc.notifyConfigRemoved(dcc);
        }

        @Override
        public void onSourceConfigUpdated(DefaultCompositeConfig dcc, Config config) {
            dcc.refreshState();
            dcc.notifyConfigUpdated(dcc);
        }

        @Override
        public void onSourceError(Throwable error, DefaultCompositeConfig dcc, Config config) {
            dcc.notifyError(error, dcc);
        }
    }

    private class State {
        private final Map<String, Config> children;
        private final CachedState cachedState;

        public State(Map<String, Config> children, int size) {
            this.children = children;
            HashMap<String, Object> data = Maps.newHashMap(size);
            HashMap<String, Config> instrumentedKeys = new HashMap<String, Config>();
            for (Config child : children.values()) {
                boolean instrumented = child.instrumentationEnabled();
                child.forEachPropertyUninstrumented((k, v) -> this.updateData((Map<String, Object>)data, (Map<String, Config>)instrumentedKeys, (String)k, v, child, instrumented));
            }
            this.cachedState = new CachedState(data, instrumentedKeys);
        }

        private void updateData(Map<String, Object> data, Map<String, Config> instrumentedKeys, String key, Object value, Config childConfig, boolean instrumented) {
            if (!data.containsKey(key)) {
                if (instrumented) {
                    instrumentedKeys.put(key, childConfig);
                }
                data.put(key, value);
            }
        }

        State addConfig(String name, Config config) {
            LinkedHashMap<String, Config> children = Maps.newLinkedHashMap(this.children.size() + 1);
            if (DefaultCompositeConfig.this.reversed) {
                children.put(name, config);
                children.putAll(this.children);
            } else {
                children.putAll(this.children);
                children.put(name, config);
            }
            Iterable keysIterable = config.keys();
            int size = keysIterable instanceof Collection ? ((Collection)keysIterable).size() : 16;
            return new State(children, this.cachedState.getData().size() + size);
        }

        State removeConfig(String name) {
            if (this.children.containsKey(name)) {
                LinkedHashMap<String, Config> children = new LinkedHashMap<String, Config>(this.children);
                children.remove(name);
                return new State(children, this.cachedState.getData().size());
            }
            return this;
        }

        public State refresh() {
            return new State(this.children, this.cachedState.getData().size());
        }

        Config getConfig(String name) {
            return this.children.get(name);
        }

        boolean containsConfig(String name) {
            return this.getConfig(name) != null;
        }
    }

    public static class Builder {
        LinkedHashMap<String, Config> configs = new LinkedHashMap();

        public Builder withConfig(String name, Config config) {
            this.configs.put(name, config);
            return this;
        }

        public CompositeConfig build() throws ConfigException {
            DefaultCompositeConfig config = new DefaultCompositeConfig();
            for (Map.Entry<String, Config> entry : this.configs.entrySet()) {
                config.addConfig(entry.getKey(), entry.getValue());
            }
            return config;
        }
    }
}

