/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.exceptions.ParseException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

abstract class AbstractRegistryDecoder
implements Decoder,
TypeConverter.Registry {
    private final Map<Type, TypeConverter<?>> cache = new ConcurrentHashMap();
    private final List<TypeConverter.Factory> factories;

    AbstractRegistryDecoder(Collection<? extends TypeConverter.Factory> factories) {
        this.factories = Collections.unmodifiableList(new ArrayList<TypeConverter.Factory>(factories));
    }

    public <T> T decode(Class<T> type, String encoded) {
        return this.decode((Type)type, encoded);
    }

    public <T> T decode(Type type, String encoded) {
        try {
            if (encoded == null) {
                return null;
            }
            TypeConverter<?> converter = this.getOrCreateConverter(type);
            if (converter == null) {
                throw new RuntimeException("No converter found for type '" + type + "'");
            }
            return (T)converter.convert(encoded);
        }
        catch (Exception e) {
            throw new ParseException("Error decoding type `" + type.getTypeName() + "`", e);
        }
    }

    public Optional<TypeConverter<?>> get(Type type) {
        return Optional.ofNullable(this.getOrCreateConverter(type));
    }

    private TypeConverter<?> getOrCreateConverter(Type type) {
        TypeConverter<?> converter = this.cache.get(type);
        if (converter == null) {
            converter = this.resolve(type);
            if (converter == null) {
                return null;
            }
            TypeConverter<?> existing = this.cache.putIfAbsent(type, converter);
            if (existing != null) {
                converter = existing;
            }
        }
        return converter;
    }

    private TypeConverter<?> resolve(Type type) {
        return this.factories.stream().flatMap(factory -> factory.get(type, (TypeConverter.Registry)this).map(Stream::of).orElseGet(Stream::empty)).findFirst().orElseGet(() -> AbstractRegistryDecoder.findValueOfTypeConverter(type));
    }

    private static <T> TypeConverter<T> findValueOfTypeConverter(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class cls = (Class)type;
        try {
            Method method = cls.getMethod("valueOf", String.class);
            return value -> {
                try {
                    return method.invoke(null, value);
                }
                catch (Exception e) {
                    throw new ParseException("Error converting value '" + value + "' to '" + type.getTypeName() + "'", e);
                }
            };
        }
        catch (NoSuchMethodException e1) {
            try {
                Constructor c = cls.getConstructor(String.class);
                return value -> {
                    try {
                        return c.newInstance(value);
                    }
                    catch (Exception e) {
                        throw new ParseException("Error converting value", e);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }
}

