/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.PropertyDetails;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.CachedState;
import java.util.Iterator;
import java.util.function.BiConsumer;

public abstract class AbstractDependentConfig
extends AbstractConfig {
    public AbstractDependentConfig(String name) {
        super(name);
    }

    public AbstractDependentConfig() {
    }

    abstract CachedState getState();

    public Object getRawProperty(String key) {
        Object value = this.getState().getData().get(key);
        if (this.getState().getInstrumentedKeys().containsKey(key)) {
            this.getState().getInstrumentedKeys().get(key).recordUsage(this.createPropertyDetails(key, value));
        }
        return value;
    }

    public Object getRawPropertyUninstrumented(String key) {
        return this.getState().getData().get(key);
    }

    public Iterator<String> getKeys() {
        return this.getState().getData().keySet().iterator();
    }

    public Iterable<String> keys() {
        return this.getState().getData().keySet();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.getState().getData().forEach((k, v) -> {
            if (this.getState().getInstrumentedKeys().containsKey(k)) {
                this.getState().getInstrumentedKeys().get(k).recordUsage(this.createPropertyDetails((String)k, v));
            }
            consumer.accept((String)k, v);
        });
    }

    public void forEachPropertyUninstrumented(BiConsumer<String, Object> consumer) {
        this.getState().getData().forEach(consumer);
    }

    public boolean containsKey(String key) {
        return this.getState().getData().containsKey(key);
    }

    public boolean isEmpty() {
        return this.getState().getData().isEmpty();
    }

    public void recordUsage(PropertyDetails propertyDetails) {
        if (this.getState().getInstrumentedKeys().containsKey(propertyDetails.getKey())) {
            this.getState().getInstrumentedKeys().get(propertyDetails.getKey()).recordUsage(propertyDetails);
        }
    }

    public boolean instrumentationEnabled() {
        return !this.getState().getInstrumentedKeys().isEmpty();
    }

    protected PropertyDetails createPropertyDetails(String key, Object value) {
        return new PropertyDetails(key, null, value);
    }
}

