/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.config.AbstractConfig;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Optional;

abstract class DependentConfigListener<T extends AbstractConfig>
implements ConfigListener {
    private final Reference<T> dependentConfigRef;

    DependentConfigListener(T dependentConfig) {
        this.dependentConfigRef = new WeakReference<T>(dependentConfig);
    }

    public void onConfigAdded(Config config) {
        this.updateState(config).ifPresent(depConfig -> this.onSourceConfigAdded(depConfig, config));
    }

    public void onConfigRemoved(Config config) {
        this.updateState(config).ifPresent(depConfig -> this.onSourceConfigRemoved(depConfig, config));
    }

    public void onConfigUpdated(Config config) {
        this.updateState(config).ifPresent(depConfig -> this.onSourceConfigUpdated(depConfig, config));
    }

    public void onError(Throwable error, Config config) {
        this.updateState(config).ifPresent(depConfig -> this.onSourceError(error, depConfig, config));
    }

    public abstract void onSourceConfigAdded(T var1, Config var2);

    public abstract void onSourceConfigRemoved(T var1, Config var2);

    public abstract void onSourceConfigUpdated(T var1, Config var2);

    public abstract void onSourceError(Throwable var1, T var2, Config var3);

    private Optional<T> updateState(Config updatedSourceConfig) {
        AbstractConfig dependentConfig = (AbstractConfig)this.dependentConfigRef.get();
        if (dependentConfig != null) {
            return Optional.of(dependentConfig);
        }
        updatedSourceConfig.removeListener((ConfigListener)this);
        return Optional.empty();
    }
}

