/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.api.annotations.DefaultValue;
import com.netflix.archaius.api.annotations.PropertyName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProxyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigProxyFactory.class);
    private static final Map<Config, Integer> FACTORIES_COUNT = Collections.synchronizedMap(new WeakHashMap());
    private static final String EXCESSIVE_PROXIES_LIMIT = "archaius.excessiveProxiesLogging.limit";
    private final Map<InterfaceAndPrefix, Integer> PROXIES_COUNT = Collections.synchronizedMap(new WeakHashMap());
    private final Decoder decoder;
    private final PropertyRepository propertyRepository;
    private final Config config;
    private final int excessiveProxyLimit;
    private static final Map<Type, Function<Object[], ?>> knownCollections = new HashMap();

    @Inject
    public ConfigProxyFactory(Config config, Decoder decoder, PropertyFactory factory) {
        this.decoder = decoder;
        this.config = config;
        this.propertyRepository = factory;
        this.excessiveProxyLimit = config.getInteger(EXCESSIVE_PROXIES_LIMIT, Integer.valueOf(5));
        ConfigProxyFactory.warnWhenTooMany(FACTORIES_COUNT, config, this.excessiveProxyLimit, () -> String.format("ProxyFactory(Config:%s)", config.hashCode()));
    }

    @Deprecated
    public ConfigProxyFactory(Config config) {
        this(config, config.getDecoder(), DefaultPropertyFactory.from(config));
    }

    @Deprecated
    public ConfigProxyFactory(Config config, PropertyFactory factory) {
        this(config, config.getDecoder(), factory);
    }

    public <T> T newProxy(Class<T> type) {
        return this.newProxy(type, null);
    }

    public <T> T newProxy(Class<T> type, String initialPrefix) {
        Configuration annot = type.getAnnotation(Configuration.class);
        return this.newProxy(type, initialPrefix, annot != null && annot.immutable());
    }

    <T> T newProxy(Class<T> type, String initialPrefix, boolean immutable) {
        Configuration annot = type.getAnnotation(Configuration.class);
        String prefix = this.derivePrefix(annot, initialPrefix);
        ConfigProxyFactory.warnWhenTooMany(this.PROXIES_COUNT, new InterfaceAndPrefix(type, prefix), this.excessiveProxyLimit, () -> String.format("Proxy(%s, %s)", type, prefix));
        HashMap invokers = new HashMap();
        HashMap<Method, String> propertyNames = new HashMap<Method, String>();
        ConfigProxyInvocationHandler<T> handler = new ConfigProxyInvocationHandler<T>(type, prefix, invokers, propertyNames);
        Object proxyObject = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
        for (Method method : type.getMethods()) {
            MethodInvokerHolder methodInvokerHolder = this.buildInvokerForMethod(type, prefix, method, proxyObject, immutable);
            propertyNames.put(method, methodInvokerHolder.propertyName);
            if (immutable) {
                Object value = methodInvokerHolder.invoker.invoke(new Object[0]);
                invokers.put(method, args -> value);
                continue;
            }
            invokers.put(method, methodInvokerHolder.invoker);
        }
        return (T)proxyObject;
    }

    private String derivePrefix(Configuration annot, String prefix) {
        if (prefix == null && annot != null && (prefix = annot.prefix()) == null) {
            prefix = "";
        }
        if (prefix == null) {
            return "";
        }
        if (prefix.endsWith(".") || prefix.isEmpty()) {
            return prefix;
        }
        return prefix + ".";
    }

    private <T> MethodInvokerHolder buildInvokerForMethod(Class<T> type, String prefix, Method m, T proxyObject, boolean immutable) {
        try {
            PropertyValueGetter<?> propertyValueGetter;
            Class<?> returnType = m.getReturnType();
            PropertyName nameAnnot = m.getAnnotation(PropertyName.class);
            String propName = ConfigProxyFactory.getPropertyName(prefix, m, nameAnnot);
            Function<Object[], Object> defaultValueSupplier = m.getAnnotation(DefaultValue.class) != null ? ConfigProxyFactory.createAnnotatedMethodSupplier(m, returnType, this.config, this.decoder) : (m.isDefault() ? ConfigProxyFactory.createDefaultMethodSupplier(m, type, proxyObject) : knownCollections.getOrDefault(returnType, ignored -> null));
            if (!knownCollections.containsKey(returnType) && returnType.isInterface()) {
                propertyValueGetter = this.createInterfaceProperty(propName, this.newProxy(returnType, propName, immutable));
            } else if (m.getParameterCount() > 0) {
                if (nameAnnot == null) {
                    throw new IllegalArgumentException("Missing @PropertyName annotation on " + m.getDeclaringClass().getName() + "#" + m.getName());
                }
                String propertyNameTemplate = !StringUtils.isBlank((CharSequence)prefix) && !nameAnnot.name().startsWith(prefix) ? prefix + nameAnnot.name() : nameAnnot.name();
                propertyValueGetter = this.createParameterizedProperty(returnType, propertyNameTemplate, defaultValueSupplier);
            } else {
                propertyValueGetter = this.createScalarProperty(m.getGenericReturnType(), propName, defaultValueSupplier);
            }
            return new MethodInvokerHolder(propertyValueGetter, propName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error proxying method " + m.getName(), e);
        }
    }

    private static String getPropertyName(String prefix, Method m, PropertyName nameAnnot) {
        String verb = m.getName().startsWith("get") ? "get" : (m.getName().startsWith("is") ? "is" : "");
        return nameAnnot != null && nameAnnot.name() != null ? prefix + nameAnnot.name() : prefix + Character.toLowerCase(m.getName().charAt(verb.length())) + m.getName().substring(verb.length() + 1);
    }

    private static <T> Function<Object[], T> createAnnotatedMethodSupplier(Method m, Class<T> returnType, Config config, Decoder decoder) {
        if (m.isDefault()) {
            throw new IllegalArgumentException("@DefaultValue cannot be defined on a method with a default implementation for method " + m.getDeclaringClass().getName() + "#" + m.getName());
        }
        if (Map.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || Set.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("@DefaultValue cannot be used with collections.  Use default method implemenation instead " + m.getDeclaringClass().getName() + "#" + m.getName());
        }
        String value = m.getAnnotation(DefaultValue.class).value();
        if (returnType == String.class) {
            return ConfigProxyFactory.memoize(config.resolve(value));
        }
        return ConfigProxyFactory.memoize(decoder.decode(returnType, config.resolve(value)));
    }

    private static <T> Function<Object[], T> memoize(T value) {
        return ignored -> value;
    }

    private static <T> Function<Object[], T> createDefaultMethodSupplier(Method method, Class<T> type, T proxyObject) {
        MethodHandle methodHandle;
        try {
            if (SystemUtils.IS_JAVA_1_8) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                methodHandle = ((MethodHandles.Lookup)constructor.newInstance(type, 2)).unreflectSpecial(method, type).bindTo(proxyObject);
            } else {
                methodHandle = MethodHandles.lookup().findSpecial(type, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), type).bindTo(proxyObject);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create temporary object for " + type.getName(), e);
        }
        return args -> {
            try {
                if (methodHandle.type().parameterCount() == 0) {
                    return methodHandle.invokeWithArguments(new Object[0]);
                }
                if (args != null) {
                    return methodHandle.invokeWithArguments(args);
                }
                return null;
            }
            catch (Throwable e) {
                ConfigProxyFactory.maybeWrapThenRethrow(e);
                return null;
            }
        };
    }

    protected <T> PropertyValueGetter<T> createInterfaceProperty(String propName, T proxy) {
        LOG.debug("Creating interface property `{}` for type `{}`", (Object)propName, proxy.getClass());
        return args -> proxy;
    }

    protected <T> PropertyValueGetter<T> createScalarProperty(Type type, String propName, Function<Object[], T> defaultValueSupplier) {
        LOG.debug("Creating scalar property `{}` for type `{}`", (Object)propName, type.getClass());
        Property prop = this.propertyRepository.get(propName, type);
        return args -> {
            Object value = prop.get();
            return value != null ? value : defaultValueSupplier.apply(null);
        };
    }

    protected <T> PropertyValueGetter<T> createParameterizedProperty(Class<T> returnType, String propertyNameTemplate, Function<Object[], T> defaultValueSupplier) {
        LOG.debug("Creating parameterized property `{}` for type `{}`", (Object)propertyNameTemplate, returnType);
        return args -> {
            if (args == null) {
                return defaultValueSupplier.apply(null);
            }
            String interpolatedPropertyName = new StrSubstitutor(new ArrayLookup(args), "${", "}", '$').replace(propertyNameTemplate);
            Object result = this.propertyRepository.get(interpolatedPropertyName, returnType).get();
            if (result == null) {
                result = defaultValueSupplier.apply(args);
            }
            return result;
        };
    }

    private static void maybeWrapThenRethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static <T> void warnWhenTooMany(Map<T, Integer> counters, T countKey, int limit, Supplier<String> objectDescription) {
        int currentCount = counters.merge(countKey, 1, Integer::sum);
        if (LOG.isWarnEnabled() && currentCount >= limit && currentCount % limit == 0) {
            LOG.warn("Too many {} objects are being created ({} so far).\nPlease review the calling code to prevent memory leaks.\nNormal usage for ConfigProxyFactory is to create singletons via your DI mechanism.\nFor special use cases that *require* creating multiple instances you can tune reporting\nby setting the `{}` config key to a higher threshold.\nStack trace for debugging follows:", new Object[]{objectDescription.get(), currentCount, EXCESSIVE_PROXIES_LIMIT, new Throwable()});
        }
    }

    static {
        knownCollections.put((Type)((Object)Map.class), ignored -> Collections.emptyMap());
        knownCollections.put((Type)((Object)Set.class), ignored -> Collections.emptySet());
        knownCollections.put((Type)((Object)SortedSet.class), ignored -> Collections.emptySortedSet());
        knownCollections.put((Type)((Object)List.class), ignored -> Collections.emptyList());
        knownCollections.put((Type)((Object)LinkedList.class), ignored -> new LinkedList());
    }

    private static class ArrayLookup<V>
    extends StrLookup<V> {
        private final V[] elements;

        private ArrayLookup(V[] elements) {
            this.elements = elements;
        }

        public String lookup(String key) {
            if (this.elements == null || this.elements.length == 0 || StringUtils.isBlank((CharSequence)key)) {
                return null;
            }
            try {
                int index = Integer.parseInt(key);
                if (index < 0 || index >= this.elements.length || this.elements[index] == null) {
                    return null;
                }
                return this.elements[index].toString();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    private static final class InterfaceAndPrefix {
        final Class<?> configInterface;
        final String prefix;

        private InterfaceAndPrefix(Class<?> configInterface, String prefix) {
            this.configInterface = configInterface;
            this.prefix = prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterfaceAndPrefix that = (InterfaceAndPrefix)o;
            return Objects.equals(this.configInterface, that.configInterface) && Objects.equals(this.prefix, that.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.configInterface, this.prefix);
        }
    }

    private static class MethodInvokerHolder<T> {
        final PropertyValueGetter<T> invoker;
        final String propertyName;

        private MethodInvokerHolder(PropertyValueGetter<T> invoker, String propertyName) {
            this.invoker = invoker;
            this.propertyName = propertyName;
        }
    }

    private static class ConfigProxyInvocationHandler<P>
    implements InvocationHandler {
        private final Map<Method, PropertyValueGetter<?>> invokers;
        private final Class<P> type;
        private final String prefix;
        private final Map<Method, String> propertyNames;

        public ConfigProxyInvocationHandler(Class<P> proxiedClass, String prefix, Map<Method, PropertyValueGetter<?>> invokers, Map<Method, String> propertyNames) {
            this.invokers = invokers;
            this.type = proxiedClass;
            this.prefix = prefix;
            this.propertyNames = propertyNames;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws NoSuchMethodError {
            PropertyValueGetter<?> invoker = this.invokers.get(method);
            if (invoker != null) {
                return invoker.invoke(args);
            }
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "toString": {
                    return this.proxyToString();
                }
            }
            throw new NoSuchMethodError(method.getName() + " not found on interface " + this.type.getName());
        }

        private String proxyToString() {
            String propertyNamesAndValues = this.invokers.entrySet().stream().map(this::toNameAndValue).collect(Collectors.joining(","));
            return String.format("%s[%s]", this.type.getSimpleName(), propertyNamesAndValues);
        }

        private String toNameAndValue(Map.Entry<Method, PropertyValueGetter<?>> entry) {
            String propertyValue;
            String propertyName = this.propertyNames.get(entry.getKey()).substring(this.prefix.length());
            try {
                propertyValue = entry.getValue().invoke(null);
            }
            catch (Exception e) {
                propertyValue = e.getMessage();
            }
            return String.format("%s='%s'", propertyName, propertyValue);
        }
    }

    static interface PropertyValueGetter<T> {
        public T invoke(Object[] var1);
    }
}

