/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.converters;

import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.exceptions.ConverterNotFoundException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;

public final class DefaultCollectionsTypeConverterFactory
implements TypeConverter.Factory {
    public static final DefaultCollectionsTypeConverterFactory INSTANCE = new DefaultCollectionsTypeConverterFactory();

    private DefaultCollectionsTypeConverterFactory() {
    }

    public Optional<TypeConverter<?>> get(Type type, TypeConverter.Registry registry) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType().equals(Map.class)) {
                return Optional.of(this.createMapTypeConverter((TypeConverter)registry.get(parameterizedType.getActualTypeArguments()[0]).orElseThrow(() -> new ConverterNotFoundException("No converter found")), (TypeConverter)registry.get(parameterizedType.getActualTypeArguments()[1]).orElseThrow(() -> new ConverterNotFoundException("No converter found")), LinkedHashMap::new));
            }
            if (parameterizedType.getRawType().equals(Set.class)) {
                return Optional.of(this.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, LinkedHashSet::new));
            }
            if (parameterizedType.getRawType().equals(SortedSet.class)) {
                return Optional.of(this.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, TreeSet::new));
            }
            if (parameterizedType.getRawType().equals(List.class)) {
                return Optional.of(this.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, ArrayList::new));
            }
            if (parameterizedType.getRawType().equals(LinkedList.class)) {
                return Optional.of(this.createCollectionTypeConverter(parameterizedType.getActualTypeArguments()[0], registry, LinkedList::new));
            }
        }
        return Optional.empty();
    }

    private <T> TypeConverter<?> createCollectionTypeConverter(Type type, TypeConverter.Registry registry, Supplier<Collection<T>> collectionFactory) {
        TypeConverter elementConverter = (TypeConverter)registry.get(type).orElseThrow(() -> new ConverterNotFoundException("No converter found"));
        boolean ignoreEmpty = !String.class.equals((Object)type);
        return value -> {
            Collection collection = (Collection)collectionFactory.get();
            if (!value.isEmpty()) {
                Arrays.asList(value.split("\\s*,\\s*")).forEach(v -> {
                    if (!v.isEmpty() || !ignoreEmpty) {
                        collection.add(elementConverter.convert(v));
                    }
                });
            }
            return collection;
        };
    }

    private TypeConverter<?> createMapTypeConverter(TypeConverter<?> keyConverter, TypeConverter<?> valueConverter, Supplier<Map> mapFactory) {
        return s -> {
            Map result = (Map)mapFactory.get();
            Arrays.stream(s.split("\\s*,\\s*")).filter(pair -> !pair.isEmpty()).map(pair -> pair.split("\\s*=\\s*")).forEach(kv -> result.put(keyConverter.convert(kv[0]), valueConverter.convert(kv[1])));
            return Collections.unmodifiableMap(result);
        };
    }
}

