/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.config.PollingStrategy;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.polling.PollingResponse;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingDynamicConfig
extends AbstractConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PollingDynamicConfig.class);
    private volatile Map<String, String> current = Collections.emptyMap();
    private final AtomicBoolean busy = new AtomicBoolean();
    private final Callable<PollingResponse> reader;
    private final AtomicLong updateCounter = new AtomicLong();
    private final AtomicLong errorCounter = new AtomicLong();
    private final PollingStrategy strategy;

    public PollingDynamicConfig(Callable<PollingResponse> reader, PollingStrategy strategy) {
        this.reader = reader;
        this.strategy = strategy;
        strategy.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PollingDynamicConfig.this.update();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to poll configuration", e);
                }
            }
        });
    }

    public boolean containsKey(String key) {
        return this.current.containsKey(key);
    }

    public boolean isEmpty() {
        return this.current.isEmpty();
    }

    public Object getRawProperty(String key) {
        return this.current.get(key);
    }

    private void update() throws Exception {
        if (this.busy.compareAndSet(false, true)) {
            this.updateCounter.incrementAndGet();
            try {
                PollingResponse response = this.reader.call();
                if (response.hasData()) {
                    this.current = Collections.unmodifiableMap(response.getToAdd());
                    this.notifyConfigUpdated(this);
                }
            }
            catch (Exception e) {
                LOG.trace("Error reading data from remote server ", (Throwable)e);
                this.errorCounter.incrementAndGet();
                try {
                    this.notifyError(e, this);
                }
                catch (Exception e2) {
                    LOG.warn("Failed to notify error observer", (Throwable)e2);
                }
                throw e;
            }
            finally {
                this.busy.set(false);
            }
        }
    }

    public void shutdown() {
        this.strategy.shutdown();
    }

    public long getUpdateCounter() {
        return this.updateCounter.get();
    }

    public long getErrorCounter() {
        return this.errorCounter.get();
    }

    public Iterator<String> getKeys() {
        return this.current.keySet().iterator();
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.current.forEach(consumer);
    }
}

