/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.converters.ArrayTypeConverterFactory;
import com.netflix.archaius.converters.DefaultCollectionsTypeConverterFactory;
import com.netflix.archaius.converters.DefaultTypeConverterFactory;
import com.netflix.archaius.converters.EnumTypeConverterFactory;
import com.netflix.archaius.exceptions.ParseException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.inject.Singleton;

@Singleton
public class DefaultDecoder
implements Decoder,
TypeConverter.Registry {
    private Map<Type, TypeConverter> cache = new ConcurrentHashMap<Type, TypeConverter>();
    private final List<TypeConverter.Factory> factories = new ArrayList<TypeConverter.Factory>();
    public static DefaultDecoder INSTANCE = new DefaultDecoder();

    private DefaultDecoder() {
        this.factories.add(DefaultTypeConverterFactory.INSTANCE);
        this.factories.add(DefaultCollectionsTypeConverterFactory.INSTANCE);
        this.factories.add(ArrayTypeConverterFactory.INSTANCE);
        this.factories.add(EnumTypeConverterFactory.INSTANCE);
    }

    public <T> T decode(Class<T> type, String encoded) {
        return this.decode((Type)type, encoded);
    }

    public <T> T decode(Type type, String encoded) {
        try {
            if (encoded == null) {
                return null;
            }
            return (T)this.getOrCreateConverter(type).convert(encoded);
        }
        catch (Exception e) {
            throw new ParseException("Error decoding type `" + type.getTypeName() + "`", e);
        }
    }

    public Optional<TypeConverter<?>> get(Type type) {
        return Optional.ofNullable(this.getOrCreateConverter(type));
    }

    private TypeConverter<?> getOrCreateConverter(Type type) {
        TypeConverter<?> converter = this.cache.get(type);
        if (converter == null) {
            converter = this.resolve(type);
            if (converter == null) {
                throw new RuntimeException("No converter found for type '" + type + "'");
            }
            this.cache.put(type, converter);
        }
        return converter;
    }

    private TypeConverter<?> resolve(Type type) {
        return this.factories.stream().flatMap(factory -> factory.get(type, (TypeConverter.Registry)this).map(Stream::of).orElseGet(Stream::empty)).findFirst().orElseGet(() -> DefaultDecoder.findValueOfTypeConverter((Class)type));
    }

    private static <T> TypeConverter<T> findValueOfTypeConverter(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class cls = (Class)type;
        try {
            Method method = cls.getMethod("valueOf", String.class);
            return value -> {
                try {
                    return method.invoke(null, value);
                }
                catch (Exception e) {
                    throw new ParseException("Error converting value '" + value + "' to '" + type.getTypeName() + "'", e);
                }
            };
        }
        catch (NoSuchMethodException e1) {
            try {
                Constructor c = cls.getConstructor(String.class);
                return value -> {
                    try {
                        return c.newInstance(value);
                    }
                    catch (Exception e) {
                        throw new ParseException("Error converting value", e);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }
}

