/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config.polling;

import com.netflix.archaius.api.config.PollingStrategy;
import com.netflix.archaius.util.Futures;
import com.netflix.archaius.util.ThreadFactories;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedPollingStrategy
implements PollingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FixedPollingStrategy.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadFactories.newNamedDaemonThreadFactory("Archaius-Poller-%d"));
    private final long interval;
    private final TimeUnit units;

    public FixedPollingStrategy(long interval, TimeUnit units) {
        this.interval = interval;
        this.units = units;
    }

    public Future<?> execute(final Runnable callback) {
        while (true) {
            try {
                callback.run();
                break;
            }
            catch (Exception e) {
                try {
                    LOG.warn("Fail to poll the polling source", (Throwable)e);
                    this.units.sleep(this.interval);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    return Futures.immediateFailure(e);
                }
            }
        }
        return this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.run();
                }
                catch (Exception e) {
                    LOG.warn("Failed to load properties", (Throwable)e);
                }
            }
        }, this.interval, this.interval, this.units);
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

