/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Layer;
import com.netflix.archaius.api.config.LayeredConfig;
import com.netflix.archaius.config.AbstractConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLayeredConfig
extends AbstractConfig
implements LayeredConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLayeredConfig.class);
    private final ConfigListener listener;
    private volatile ImmutableCompositeState state = new ImmutableCompositeState(Collections.emptyList());
    private static final AtomicInteger insertionOrderCounter = new AtomicInteger(1);
    private static final Comparator<LayerAndConfig> ByPriorityAndInsertionOrder = (o1, o2) -> {
        int result;
        if (((LayerAndConfig)o1).layer != ((LayerAndConfig)o2).layer && (result = ((LayerAndConfig)o1).layer.getOrder() - ((LayerAndConfig)o2).layer.getOrder()) != 0) {
            return result;
        }
        return ((LayerAndConfig)o2).internalOrder - ((LayerAndConfig)o1).internalOrder;
    };

    public DefaultLayeredConfig() {
        this(DefaultLayeredConfig.generateUniqueName("layered-"));
    }

    public DefaultLayeredConfig(String name) {
        super(name);
        this.listener = new ConfigListener(){

            public void onConfigAdded(Config config) {
                DefaultLayeredConfig.this.refreshState();
                DefaultLayeredConfig.this.notifyConfigUpdated(DefaultLayeredConfig.this);
            }

            public void onConfigRemoved(Config config) {
                DefaultLayeredConfig.this.refreshState();
                DefaultLayeredConfig.this.notifyConfigUpdated(DefaultLayeredConfig.this);
            }

            public void onConfigUpdated(Config config) {
                DefaultLayeredConfig.this.refreshState();
                DefaultLayeredConfig.this.notifyConfigUpdated(DefaultLayeredConfig.this);
            }

            public void onError(Throwable error, Config config) {
                DefaultLayeredConfig.this.notifyError(error, DefaultLayeredConfig.this);
            }
        };
    }

    private void refreshState() {
        this.state = this.state.refresh();
    }

    public boolean isEmpty() {
        return this.state.data.isEmpty();
    }

    public synchronized void addConfig(Layer layer, Config config) {
        this.addConfig(layer, config, insertionOrderCounter.incrementAndGet());
    }

    public synchronized void addConfig(Layer layer, Config child, int position) {
        LOG.info("Adding property source '{}' at layer '{}'", (Object)child.getName(), (Object)layer);
        if (child == null) {
            return;
        }
        this.state = this.state.addChild(new LayerAndConfig(layer, child, position));
        child.setStrInterpolator(this.getStrInterpolator());
        child.setDecoder(this.getDecoder());
        this.notifyConfigUpdated(this);
        child.addListener(this.listener);
    }

    public Collection<Config> getConfigsAtLayer(Layer layer) {
        return this.state.children.stream().filter(holder -> ((LayerAndConfig)holder).layer.equals((Object)layer)).map(holder -> ((LayerAndConfig)holder).config).collect(Collectors.toList());
    }

    public synchronized Optional<Config> removeConfig(Layer layer, String name) {
        LOG.info("Removing property source '{}' from layer '{}'", (Object)name, (Object)layer);
        Optional<Config> previous = this.state.findChild(layer, name);
        if (previous.isPresent()) {
            this.state = this.state.removeChild(layer, name);
            this.notifyConfigUpdated(this);
        }
        return previous;
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.state.data.forEach(consumer);
    }

    public Optional<Object> getProperty(String key) {
        return Optional.ofNullable(this.state.data.get(key));
    }

    public Object getRawProperty(String key) {
        return this.state.data.get(key);
    }

    public boolean containsKey(String key) {
        return this.state.data.containsKey(key);
    }

    public Iterator<String> getKeys() {
        return this.state.data.keySet().iterator();
    }

    private class ImmutableCompositeState {
        private final List<LayerAndConfig> children;
        private final Map<String, Object> data;

        ImmutableCompositeState(List<LayerAndConfig> entries) {
            this.children = entries;
            this.children.sort(ByPriorityAndInsertionOrder);
            this.data = new HashMap<String, Object>();
            this.children.forEach(child -> ((LayerAndConfig)child).config.forEachProperty(this.data::putIfAbsent));
        }

        public ImmutableCompositeState addChild(LayerAndConfig layerAndConfig) {
            ArrayList<LayerAndConfig> newChildren = new ArrayList<LayerAndConfig>(this.children);
            newChildren.add(layerAndConfig);
            return new ImmutableCompositeState(newChildren);
        }

        public ImmutableCompositeState removeChild(Layer layer, String name) {
            ArrayList<LayerAndConfig> newChildren = new ArrayList<LayerAndConfig>(this.children.size());
            this.children.stream().filter(source -> !source.getLayer().equals((Object)layer) || source.getConfig().getName() == null).forEach(newChildren::add);
            newChildren.sort(ByPriorityAndInsertionOrder);
            return new ImmutableCompositeState(newChildren);
        }

        public Optional<Config> findChild(Layer layer, String name) {
            return this.children.stream().filter(source -> ((LayerAndConfig)source).layer.equals((Object)layer) && ((LayerAndConfig)source).config.getName().equals(name)).findFirst().map(LayerAndConfig::getConfig);
        }

        ImmutableCompositeState refresh() {
            return new ImmutableCompositeState(this.children);
        }
    }

    private static class LayerAndConfig {
        private final Layer layer;
        private final int internalOrder;
        private final Config config;

        private LayerAndConfig(Layer layer, Config config, int internalOrder) {
            this.layer = layer;
            this.internalOrder = internalOrder;
            this.config = config;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 + (this.config == null ? 0 : this.config.hashCode());
            result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
            return result;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public Config getConfig() {
            return this.config;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LayerAndConfig other = (LayerAndConfig)obj;
            if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
                return false;
            }
            return !(this.layer == null ? other.layer != null : !this.layer.equals((Object)other.layer));
        }

        public String toString() {
            return "Element [layer=" + this.layer + ", id=" + this.internalOrder + ", value=" + this.config + "]";
        }
    }
}

