/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.AbstractProperty;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.PropertyRepository;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.api.annotations.DefaultValue;
import com.netflix.archaius.api.annotations.PropertyName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.text.StrSubstitutor;

public class ConfigProxyFactory {
    private final Decoder decoder;
    private final PropertyRepository propertyRepository;
    private final Config config;

    @Inject
    public ConfigProxyFactory(Config config, Decoder decoder, PropertyFactory factory) {
        this.decoder = decoder;
        this.config = config;
        this.propertyRepository = factory;
    }

    @Deprecated
    public ConfigProxyFactory(Config config, PropertyFactory factory) {
        this.decoder = config.getDecoder();
        this.config = config;
        this.propertyRepository = factory;
    }

    @Deprecated
    public ConfigProxyFactory(Config config) {
        this.decoder = config.getDecoder();
        this.config = config;
        this.propertyRepository = DefaultPropertyFactory.from(config);
    }

    public <T> T newProxy(Class<T> type) {
        return this.newProxy(type, null);
    }

    private String derivePrefix(Configuration annot, String prefix) {
        if (prefix == null && annot != null && (prefix = annot.prefix()) == null) {
            prefix = "";
        }
        if (prefix == null) {
            return "";
        }
        if (prefix.endsWith(".") || prefix.isEmpty()) {
            return prefix;
        }
        return prefix + ".";
    }

    public <T> T newProxy(Class<T> type, String initialPrefix) {
        Configuration annot = type.getAnnotation(Configuration.class);
        return this.newProxy(type, initialPrefix, annot == null ? false : annot.immutable());
    }

    <T> T newProxy(Class<T> type, String initialPrefix, boolean immutable) {
        MethodHandles.Lookup lookup;
        Configuration annot = type.getAnnotation(Configuration.class);
        String prefix = this.derivePrefix(annot, initialPrefix);
        HashMap<Method, MethodInvoker<Object>> invokers = new HashMap<Method, MethodInvoker<Object>>();
        HashMap<Method, String> propertyNames = new HashMap<Method, String>();
        InvocationHandler handler = (proxy, method, args) -> {
            MethodInvoker invoker = (MethodInvoker)invokers.get(method);
            if (invoker != null) {
                return invoker.invoke(args);
            }
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            if ("toString".equals(method.getName())) {
                StringBuilder sb = new StringBuilder();
                sb.append(type.getSimpleName()).append("[");
                sb.append(invokers.entrySet().stream().map(entry -> {
                    StringBuilder sbProperty = new StringBuilder();
                    sbProperty.append(((String)propertyNames.get(entry.getKey())).substring(prefix.length())).append("='");
                    try {
                        sbProperty.append(((MethodInvoker)entry.getValue()).invoke(null));
                    }
                    catch (Exception e) {
                        sbProperty.append(e.getMessage());
                    }
                    sbProperty.append("'");
                    return sbProperty.toString();
                }).collect(Collectors.joining(",")));
                sb.append("]");
                return sb.toString();
            }
            throw new NoSuchMethodError(method.getName() + " not found on interface " + type.getName());
        };
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            lookup = (MethodHandles.Lookup)constructor.newInstance(type, 2);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create temporary object for " + type.getName(), e);
        }
        Object proxyObject = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
        for (Method m : type.getMethods()) {
            try {
                MethodInvoker<Object> invoker;
                PropertyName nameAnnot;
                String verb = m.getName().startsWith("get") ? "get" : (m.getName().startsWith("is") ? "is" : "");
                Class<?> returnType = m.getReturnType();
                Supplier<Object> defaultSupplier = () -> null;
                if (m.getAnnotation(DefaultValue.class) != null) {
                    if (m.isDefault()) {
                        throw new IllegalArgumentException("@DefaultValue cannot be defined on a method with a default implementation for method " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    if (Map.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || Set.class.isAssignableFrom(returnType)) {
                        throw new IllegalArgumentException("@DefaultValue cannot be used with collections.  Use default method implemenation instead " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    String value = m.getAnnotation(DefaultValue.class).value();
                    defaultSupplier = returnType == String.class ? ConfigProxyFactory.memoize(this.config.resolve(value)) : ConfigProxyFactory.memoize(this.decoder.decode(returnType, this.config.resolve(value)));
                }
                if (m.isDefault()) {
                    defaultSupplier = new DefaultMethodValueSupplier<Object>(lookup.unreflectSpecial(m, type).bindTo(proxyObject));
                }
                String propName = (nameAnnot = m.getAnnotation(PropertyName.class)) != null && nameAnnot.name() != null ? prefix + nameAnnot.name() : prefix + Character.toLowerCase(m.getName().charAt(verb.length())) + m.getName().substring(verb.length() + 1);
                propertyNames.put(m, propName);
                if (returnType.equals(Map.class)) {
                    invoker = this.createMapProperty(propName, (ParameterizedType)m.getGenericReturnType(), LinkedHashMap::new, defaultSupplier);
                } else if (returnType.equals(Set.class)) {
                    invoker = this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), LinkedHashSet::new, defaultSupplier);
                } else if (returnType.equals(SortedSet.class)) {
                    invoker = this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), TreeSet::new, defaultSupplier);
                } else if (returnType.equals(List.class)) {
                    invoker = this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), ArrayList::new, defaultSupplier);
                } else if (returnType.equals(LinkedList.class)) {
                    invoker = this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), LinkedList::new, defaultSupplier);
                } else if (returnType.isInterface()) {
                    invoker = this.createInterfaceProperty(propName, this.newProxy(returnType, propName, immutable));
                } else if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
                    if (nameAnnot == null) {
                        throw new IllegalArgumentException("Missing @PropertyName annotation on " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    invoker = this.createParameterizedProperty(returnType, propName, nameAnnot.name(), defaultSupplier);
                } else {
                    invoker = this.createScalarProperty(returnType, propName, defaultSupplier);
                }
                if (immutable) {
                    Object value = invoker.invoke(new Object[0]);
                    invokers.put(m, args -> value);
                    continue;
                }
                invokers.put(m, invoker);
            }
            catch (Exception e) {
                throw new RuntimeException("Error proxying method " + m.getName(), e);
            }
        }
        return (T)proxyObject;
    }

    private static <T> Supplier<T> memoize(T value) {
        return () -> value;
    }

    private <T> MethodInvoker<T> createCollectionProperty(String propName, ParameterizedType type, Supplier<Collection<T>> collectionFactory, Supplier<T> next) {
        Class valueType = (Class)type.getActualTypeArguments()[0];
        Property prop = this.propertyRepository.get(propName, String.class).map(s -> {
            Collection list = (Collection)collectionFactory.get();
            if (!s.isEmpty()) {
                Arrays.asList(s.split("\\s*,\\s*")).forEach(v -> {
                    if (!v.isEmpty() || valueType == String.class) {
                        list.add(this.decoder.decode(valueType, v));
                    }
                });
            }
            return list;
        }).orElse(next.get());
        return args -> Optional.ofNullable(prop.get()).orElseGet(collectionFactory);
    }

    private <T extends Map> MethodInvoker<T> createMapProperty(String propName, ParameterizedType type, Supplier<T> mapFactory, Supplier<T> next) {
        Class keyType = (Class)type.getActualTypeArguments()[0];
        Class valueType = (Class)type.getActualTypeArguments()[1];
        Property prop = this.propertyRepository.get(propName, String.class).map(s -> {
            Map result = (Map)mapFactory.get();
            Arrays.stream(s.split("\\s*,\\s*")).filter(pair -> !pair.isEmpty()).map(pair -> pair.split("\\s*=\\s*")).forEach(kv -> result.put(this.decoder.decode(keyType, kv[0]), this.decoder.decode(valueType, kv[1])));
            return Collections.unmodifiableMap(result);
        }).orElse(Collections.unmodifiableMap((Map)next.get()));
        return args -> (Map)Optional.ofNullable(prop.get()).orElseGet(mapFactory);
    }

    protected <T> Supplier<T> defaultValueFromString(Class<T> type, String defaultValue) {
        return () -> this.decoder.decode(type, defaultValue);
    }

    protected <T> MethodInvoker<T> createInterfaceProperty(String propName, final T proxy, Supplier<T> next) {
        return new PropertyMethodInvoker<T>(propName, next){

            public T get() {
                return proxy;
            }
        };
    }

    protected <T> MethodInvoker<T> createInterfaceProperty(String propName, T proxy) {
        return args -> proxy;
    }

    protected <T> MethodInvoker<T> createScalarProperty(Class<T> type, String propName, Supplier<T> next) {
        Property prop = this.propertyRepository.get(propName, type);
        return args -> Optional.ofNullable(prop.get()).orElseGet(next);
    }

    protected <T> MethodInvoker<T> createParameterizedProperty(final Class<T> returnType, String propName, final String nameAnnot, final Supplier<T> next) {
        return new MethodInvoker<T>(){

            @Override
            public T invoke(Object[] args) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (int i = 0; i < args.length; ++i) {
                    values.put("" + i, args[i]);
                }
                String propName = new StrSubstitutor(values, "${", "}", '$').replace(nameAnnot);
                Object result = this.getPropertyWithDefault(returnType, propName);
                if (result == null) {
                    result = next.get();
                }
                return result;
            }

            <R> R getPropertyWithDefault(Class<R> type, String propName) {
                return (R)ConfigProxyFactory.this.propertyRepository.get(propName, type).get();
            }
        };
    }

    private static abstract class PropertyMethodInvoker<T>
    extends AbstractProperty<T>
    implements MethodInvoker<T> {
        private final Supplier<T> next;

        public PropertyMethodInvoker(String key, Supplier<T> next) {
            super(key);
            this.next = next;
        }

        @Override
        public T invoke(Object[] args) {
            Object result = this.get();
            if (result == null) {
                return this.next.get();
            }
            return (T)result;
        }
    }

    static class DefaultMethodValueSupplier<T>
    implements Supplier<T> {
        private final MethodHandle handle;

        DefaultMethodValueSupplier(MethodHandle handle) {
            this.handle = handle;
        }

        @Override
        public T get() {
            try {
                return (T)this.handle.invokeWithArguments(new Object[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    static interface MethodInvoker<T> {
        public T invoke(Object[] var1);
    }
}

