/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class PrefixedViewConfig
extends AbstractConfig {
    private final Config config;
    private final String prefix;
    private final StrInterpolator.Lookup nonPrefixedLookup;
    private volatile State state;

    public PrefixedViewConfig(final String prefix, Config config) {
        this.config = config;
        this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        this.nonPrefixedLookup = ConfigStrLookup.from(config);
        this.state = new State(config, prefix);
        this.config.addListener(new ConfigListener(){

            public void onConfigAdded(Config config) {
                PrefixedViewConfig.this.state = new State(config, prefix);
            }

            public void onConfigRemoved(Config config) {
                PrefixedViewConfig.this.state = new State(config, prefix);
            }

            public void onConfigUpdated(Config config) {
                PrefixedViewConfig.this.state = new State(config, prefix);
            }

            public void onError(Throwable error, Config config) {
            }
        });
    }

    public Iterator<String> getKeys() {
        return this.state.data.keySet().iterator();
    }

    public boolean containsKey(String key) {
        return this.state.data.containsKey(key);
    }

    public boolean isEmpty() {
        return this.state.data.isEmpty();
    }

    @Override
    public <T> T accept(Config.Visitor<T> visitor) {
        Object t = null;
        for (Map.Entry<String, Object> entry : this.state.data.entrySet()) {
            t = visitor.visitKey(entry.getKey(), entry.getValue());
        }
        return (T)t;
    }

    public Object getRawProperty(String key) {
        return this.state.data.get(key);
    }

    @Override
    protected StrInterpolator.Lookup getLookup() {
        return this.nonPrefixedLookup;
    }

    @Override
    public synchronized void setDecoder(Decoder decoder) {
        super.setDecoder(decoder);
        this.config.setDecoder(decoder);
    }

    @Override
    public synchronized void setStrInterpolator(StrInterpolator interpolator) {
        super.setStrInterpolator(interpolator);
        this.config.setStrInterpolator(interpolator);
    }

    @Override
    public synchronized void addListener(ConfigListener listener) {
        super.addListener(listener);
        this.config.addListener(listener);
    }

    @Override
    public synchronized void removeListener(ConfigListener listener) {
        super.removeListener(listener);
        this.config.removeListener(listener);
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.state.data.forEach(consumer);
    }

    private static class State {
        final Map<String, Object> data = new LinkedHashMap<String, Object>();

        public State(Config config, String prefix) {
            config.forEachProperty((k, v) -> {
                if (k.startsWith(prefix)) {
                    this.data.put(k.substring(prefix.length() + 1), v);
                }
            });
        }
    }
}

