/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.visitor;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.visitor.PrintStreamVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;

public class PropertyOverrideVisitor
implements CompositeConfig.CompositeVisitor<LinkedHashMap<String, String>> {
    public static PrintStreamVisitor OUT = new PrintStreamVisitor(System.out);
    private static final String SEPARATOR = "/";
    private final Stack<String> stack = new Stack();
    private final String key;
    private final LinkedHashMap<String, String> hierarchy = new LinkedHashMap();

    public PropertyOverrideVisitor(String key) {
        this.key = key;
    }

    public LinkedHashMap<String, String> visitKey(String key, Object value) {
        return this.hierarchy;
    }

    public LinkedHashMap<String, String> visitChild(String name, Config child) {
        this.stack.push(name);
        if (child instanceof CompositeConfig) {
            child.accept((Config.Visitor)this);
        } else {
            Object value = child.getRawProperty(this.key);
            if (value != null) {
                this.hierarchy.put(PropertyOverrideVisitor.join(this.stack, SEPARATOR), value.toString());
            }
        }
        this.stack.pop();
        return this.hierarchy;
    }

    private static String join(Collection<String> values, String sep) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = values.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(sep);
        }
        return sb.toString();
    }
}

