/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.property;

import com.netflix.archaius.api.PropertyListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListenerManager {
    private final ConcurrentMap<PropertyListener<?>, ListenerUpdater> lookup = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<ListenerUpdater> updaters = new CopyOnWriteArrayList();

    public void add(PropertyListener<?> listener, ListenerUpdater updater) {
        this.lookup.put(listener, updater);
        this.updaters.add(updater);
    }

    public void remove(PropertyListener<?> listener) {
        ListenerUpdater updater = (ListenerUpdater)this.lookup.remove(listener);
        if (updater != null) {
            this.updaters.remove(updater);
        }
    }

    public void updateAll() {
        for (ListenerUpdater updater : this.updaters) {
            updater.update();
        }
    }

    public static interface ListenerUpdater {
        public void update();
    }
}

