/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.config.AbstractConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class DefaultSettableConfig
extends AbstractConfig
implements SettableConfig {
    private volatile Map<String, Object> props = Collections.emptyMap();

    public synchronized <T> void setProperty(String propName, T propValue) {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.props.size() + 1);
        copy.putAll(this.props);
        copy.put(propName, propValue);
        this.props = copy;
        this.notifyConfigUpdated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperty(String propName) {
        if (this.props.containsKey(propName)) {
            DefaultSettableConfig defaultSettableConfig = this;
            synchronized (defaultSettableConfig) {
                HashMap<String, Object> copy = new HashMap<String, Object>(this.props);
                copy.remove(propName);
                this.props = copy;
                this.notifyConfigUpdated(this);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public Object getRawProperty(String key) {
        return this.props.get(key);
    }

    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Properties src) {
        if (null != src) {
            DefaultSettableConfig defaultSettableConfig = this;
            synchronized (defaultSettableConfig) {
                HashMap<String, Object> copy = new HashMap<String, Object>(this.props.size() + src.size());
                copy.putAll(this.props);
                for (Map.Entry<Object, Object> prop : src.entrySet()) {
                    copy.put(prop.getKey().toString(), prop.getValue());
                }
                this.props = copy;
                this.notifyConfigUpdated(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Config src) {
        if (null != src) {
            DefaultSettableConfig defaultSettableConfig = this;
            synchronized (defaultSettableConfig) {
                HashMap<String, Object> copy = new HashMap<String, Object>(this.props);
                src.forEachProperty(copy::put);
                this.props = copy;
                this.notifyConfigUpdated(this);
            }
        }
    }

    @Override
    public void forEachProperty(BiConsumer<String, Object> consumer) {
        this.props.forEach(consumer);
    }
}

