/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.AbstractProperty;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.ReadOnlyMap;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.api.annotations.DefaultValue;
import com.netflix.archaius.api.annotations.PropertyName;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.text.StrSubstitutor;

public class ConfigProxyFactory {
    private final Decoder decoder;
    private final PropertyFactory propertyFactory;
    private final Config config;

    @Inject
    public ConfigProxyFactory(Config config, Decoder decoder, PropertyFactory factory) {
        this.decoder = decoder;
        this.config = config;
        this.propertyFactory = factory;
    }

    @Deprecated
    public ConfigProxyFactory(Config config, PropertyFactory factory) {
        this.decoder = config.getDecoder();
        this.config = config;
        this.propertyFactory = factory;
    }

    @Deprecated
    public ConfigProxyFactory(Config config) {
        this.decoder = config.getDecoder();
        this.config = config;
        this.propertyFactory = DefaultPropertyFactory.from(config);
    }

    public <T> T newProxy(Class<T> type) {
        return this.newProxy(type, null);
    }

    private String derivePrefix(Configuration annot, String prefix) {
        if (prefix == null && annot != null && (prefix = annot.prefix()) == null) {
            prefix = "";
        }
        if (prefix == null) {
            return "";
        }
        if (prefix.endsWith(".") || prefix.isEmpty()) {
            return prefix;
        }
        return prefix + ".";
    }

    public <T> T newProxy(Class<T> type, String initialPrefix) {
        Configuration annot = type.getAnnotation(Configuration.class);
        return this.newProxy(type, initialPrefix, annot == null ? false : annot.immutable());
    }

    <T> T newProxy(Class<T> type, String initialPrefix, boolean immutable) {
        MethodHandles.Lookup temp;
        Configuration annot = type.getAnnotation(Configuration.class);
        String prefix = this.derivePrefix(annot, initialPrefix);
        HashMap invokers = new HashMap();
        for (Method m : type.getMethods()) {
            try {
                PropertyName nameAnnot;
                String propName;
                String verb = m.getName().startsWith("get") ? "get" : (m.getName().startsWith("is") ? "is" : "");
                Class<?> returnType = m.getReturnType();
                Object defaultValue = null;
                if (m.getAnnotation(DefaultValue.class) != null) {
                    if (m.isDefault()) {
                        throw new IllegalArgumentException("@DefaultValue cannot be defined on a method with a default implementation for method " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    if (Map.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || Set.class.isAssignableFrom(returnType)) {
                        throw new IllegalArgumentException("@DefaultValue cannot be used with collections.  Use default method implemenation instead " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    String value = m.getAnnotation(DefaultValue.class).value();
                    defaultValue = returnType == String.class ? this.config.getString("*", value) : this.decoder.decode(returnType, this.config.getString("*", value));
                }
                String string = propName = (nameAnnot = m.getAnnotation(PropertyName.class)) != null && nameAnnot.name() != null ? prefix + nameAnnot.name() : prefix + Character.toLowerCase(m.getName().charAt(verb.length())) + m.getName().substring(verb.length() + 1);
                if (returnType.equals(Map.class)) {
                    invokers.put(m, this.createMapProperty(propName, (ParameterizedType)m.getGenericReturnType(), immutable));
                    continue;
                }
                if (returnType.equals(Set.class)) {
                    invokers.put(m, this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), LinkedHashSet::new));
                    continue;
                }
                if (returnType.equals(SortedSet.class)) {
                    invokers.put(m, this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), TreeSet::new));
                    continue;
                }
                if (returnType.equals(List.class)) {
                    invokers.put(m, this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), ArrayList::new));
                    continue;
                }
                if (returnType.equals(LinkedList.class)) {
                    invokers.put(m, this.createCollectionProperty(propName, (ParameterizedType)m.getGenericReturnType(), LinkedList::new));
                    continue;
                }
                if (returnType.isInterface()) {
                    invokers.put(m, this.createInterfaceProperty(propName, this.newProxy(returnType, propName, immutable)));
                    continue;
                }
                if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
                    if (nameAnnot == null) {
                        throw new IllegalArgumentException("Missing @PropertyName annotation on " + m.getDeclaringClass().getName() + "#" + m.getName());
                    }
                    invokers.put(m, this.createParameterizedProperty(returnType, propName, nameAnnot.name(), defaultValue));
                    continue;
                }
                if (immutable) {
                    invokers.put(m, this.createImmutablePropertyWithDefault(returnType, propName, defaultValue));
                    continue;
                }
                invokers.put(m, this.createScalarProperty(returnType, propName, defaultValue));
            }
            catch (Exception e) {
                throw new RuntimeException("Error proxying method " + m.getName(), e);
            }
        }
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            temp = (MethodHandles.Lookup)constructor.newInstance(type, 2);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create temporary object for " + type.getName(), e);
        }
        InvocationHandler handler = (proxy, method, args) -> {
            MethodInvoker invoker = (MethodInvoker)invokers.get(method);
            if (invoker != null) {
                if (method.isDefault()) {
                    Supplier<Object> defaultSupplier = () -> {
                        try {
                            return temp.unreflectSpecial(method, type).bindTo(proxy).invokeWithArguments(new Object[0]);
                        }
                        catch (Throwable t) {
                            return null;
                        }
                    };
                    return invoker.invoke(proxy, args, defaultSupplier);
                }
                return invoker.invoke(proxy, args, () -> null);
            }
            if ("toString".equals(method.getName())) {
                StringBuilder sb = new StringBuilder();
                sb.append(type.getSimpleName()).append("[");
                Iterator iter = invokers.entrySet().iterator();
                while (iter.hasNext()) {
                    MethodInvoker entry = (MethodInvoker)iter.next().getValue();
                    sb.append(entry.getKey().substring(prefix.length())).append("='");
                    try {
                        sb.append(entry.invoke(proxy, null, () -> null));
                    }
                    catch (Exception e) {
                        sb.append(e.getMessage());
                    }
                    sb.append("'");
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append("]");
                return sb.toString();
            }
            throw new NoSuchMethodError(method.getName() + " not found on interface " + type.getName());
        };
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
    }

    protected <T> MethodInvoker<T> createCustomProperty(Function<String, T> converter, String propName) {
        final Property prop = this.propertyFactory.getProperty(propName).asType(converter, null);
        return new MethodInvoker<T>(){

            @Override
            public T invoke(Object obj, Object[] args, Supplier<T> defaultValueSupplier) {
                Object value = prop.get();
                if (value == null) {
                    value = defaultValueSupplier.get();
                }
                return value;
            }

            @Override
            public String getKey() {
                return prop.getKey();
            }
        };
    }

    private <T> MethodInvoker<T> createCollectionProperty(String propName, ParameterizedType type, final Supplier<Collection> collectionFactory) {
        Class valueType = (Class)type.getActualTypeArguments()[0];
        final Property prop = this.propertyFactory.getProperty(propName).asType(s -> {
            if (s != null) {
                Collection list = (Collection)collectionFactory.get();
                if (!s.isEmpty()) {
                    Arrays.asList(s.split("\\s*,\\s*")).forEach(v -> {
                        if (!v.isEmpty() || valueType == String.class) {
                            list.add(this.decoder.decode(valueType, v));
                        }
                    });
                }
                return list;
            }
            return null;
        }, null);
        return new MethodInvoker<T>(){

            @Override
            public T invoke(Object obj, Object[] args, Supplier<T> defaultValueSupplier) {
                Object value = prop.get();
                if (value == null) {
                    value = defaultValueSupplier.get();
                }
                if (value == null) {
                    value = collectionFactory.get();
                }
                return value;
            }

            @Override
            public String getKey() {
                return prop.getKey();
            }
        };
    }

    private <T> MethodInvoker<T> createMapProperty(final String propName, ParameterizedType type, final boolean immutable) {
        final Class valueType = (Class)type.getActualTypeArguments()[1];
        ReadOnlyMap<String, Object> map = valueType.isInterface() ? new ReadOnlyMap<String, Object>(){
            Map<String, Object> lookup = new ConcurrentHashMap<String, Object>();

            @Override
            public Object get(Object key) {
                return this.lookup.computeIfAbsent((String)key, new Function<String, Object>(){

                    @Override
                    public Object apply(String key) {
                        return ConfigProxyFactory.this.newProxy(valueType, propName + "." + key, immutable);
                    }
                });
            }
        } : new ReadOnlyMap<String, Object>(){

            @Override
            public Object get(Object key) {
                return ConfigProxyFactory.this.config.get(valueType, propName + "." + key);
            }
        };
        return this.createInterfaceProperty(propName, map);
    }

    protected <T> Supplier<T> defaultValueFromString(Class<T> type, String defaultValue) {
        return () -> this.decoder.decode(type, defaultValue);
    }

    protected <T> MethodInvoker<T> createImmutablePropertyWithDefault(final Class<T> type, final String propName, final Object defaultValue) {
        return new PropertyMethodInvoker<T>(propName){
            private volatile T cached;

            @Override
            public T invoke(Object obj, Object[] args, Supplier<T> defaultValueSupplier) {
                if (this.cached == null) {
                    this.cached = this.get();
                }
                if (this.cached == null) {
                    this.cached = defaultValueSupplier.get();
                }
                return this.cached;
            }

            public T get() {
                return ConfigProxyFactory.this.propertyFactory.getProperty(propName).asType(type, defaultValue).get();
            }
        };
    }

    protected <T> MethodInvoker<T> createInterfaceProperty(String propName, final T proxy) {
        return new PropertyMethodInvoker<T>(propName){

            public T get() {
                return proxy;
            }
        };
    }

    protected <T> MethodInvoker<T> createScalarProperty(Class<T> type, String propName, Object defaultValue) {
        final Property prop = this.propertyFactory.getProperty(propName).asType(type, defaultValue);
        return new MethodInvoker<T>(){

            @Override
            public T invoke(Object obj, Object[] args, Supplier<T> defaultValueSupplier) {
                Object result = prop.get();
                if (result == null) {
                    result = defaultValueSupplier.get();
                }
                return result;
            }

            @Override
            public String getKey() {
                return prop.getKey();
            }
        };
    }

    protected <T> MethodInvoker<T> createParameterizedProperty(final Class<T> returnType, final String propName, final String nameAnnot, final Object defaultValue) {
        return new MethodInvoker<T>(){

            @Override
            public T invoke(Object obj, Object[] args, Supplier<T> defaultValueSupplier) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (int i = 0; i < args.length; ++i) {
                    values.put("" + i, args[i]);
                }
                String propName2 = new StrSubstitutor(values, "${", "}", '$').replace(nameAnnot);
                Object result = this.getPropertyWithDefault(returnType, propName2, defaultValue);
                if (result == null) {
                    result = defaultValueSupplier.get();
                }
                return result;
            }

            <R> R getPropertyWithDefault(Class<R> type, String propName2, R defaultValue2) {
                return (R)ConfigProxyFactory.this.propertyFactory.getProperty(propName2).asType(type, defaultValue2).get();
            }

            @Override
            public String getKey() {
                return propName;
            }
        };
    }

    private static abstract class PropertyMethodInvoker<T>
    extends AbstractProperty<T>
    implements MethodInvoker<T> {
        public PropertyMethodInvoker(String key) {
            super(key);
        }

        @Override
        public T invoke(Object Obj, Object[] args, Supplier<T> defaultValueSupplier) {
            Object result = this.get();
            if (result == null) {
                result = defaultValueSupplier.get();
            }
            return (T)result;
        }
    }

    public static interface MethodInvoker<T> {
        public T invoke(Object var1, Object[] var2, Supplier<T> var3);

        public String getKey();
    }
}

