/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.config.AbstractConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MapConfig
extends AbstractConfig {
    private Map<String, String> props = new HashMap<String, String>();

    public static Builder builder() {
        return new Builder();
    }

    public static MapConfig from(Properties props) {
        return new MapConfig(props);
    }

    public static MapConfig from(Map<String, String> props) {
        return new MapConfig(props);
    }

    public MapConfig(Map<String, String> props) {
        this.props.putAll(props);
        this.props = Collections.unmodifiableMap(this.props);
    }

    public MapConfig(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        this.props = Collections.unmodifiableMap(this.props);
    }

    public Object getRawProperty(String key) {
        return this.props.get(key);
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public Iterator<String> getKeys() {
        return this.props.keySet().iterator();
    }

    public static class Builder {
        Map<String, String> map = new HashMap<String, String>();

        public <T> Builder put(String key, T value) {
            this.map.put(key, value.toString());
            return this;
        }

        public MapConfig build() {
            return new MapConfig(this.map);
        }
    }
}

