/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.exceptions.ParseException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Singleton;

@Singleton
public class DefaultDecoder
implements Decoder {
    public static DefaultDecoder INSTANCE = new DefaultDecoder();

    public <T> T decode(Class<T> type, String encoded) {
        if (encoded == null) {
            return null;
        }
        if (type.equals(String.class)) {
            return (T)encoded;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            if (encoded.equalsIgnoreCase("true") || encoded.equalsIgnoreCase("yes") || encoded.equalsIgnoreCase("on")) {
                return (T)Boolean.TRUE;
            }
            if (encoded.equalsIgnoreCase("false") || encoded.equalsIgnoreCase("no") || encoded.equalsIgnoreCase("off")) {
                return (T)Boolean.FALSE;
            }
            throw new ParseException("Error parsing value '" + encoded, new Exception("Expected one of [true, yes, on, false, no, off]"));
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (T)Integer.valueOf(encoded);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (T)Long.valueOf(encoded);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (T)Short.valueOf(encoded);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return (T)Double.valueOf(encoded);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return (T)Float.valueOf(encoded);
        }
        if (type.equals(BigInteger.class)) {
            return (T)new BigInteger(encoded);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)new BigDecimal(encoded);
        }
        if (type.isArray()) {
            String[] elements = encoded.split(",");
            Object[] ar = (Object[])Array.newInstance(type.getComponentType(), elements.length);
            for (int i = 0; i < elements.length; ++i) {
                ar[i] = this.decode(type.getComponentType(), elements[i]);
            }
            return (T)ar;
        }
        try {
            try {
                Method method = type.getMethod("valueOf", String.class);
                return (T)method.invoke(null, encoded);
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor<T> c = type.getConstructor(String.class);
                    return c.newInstance(encoded);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(type.getCanonicalName() + " has no String constructor or valueOf static method");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate value of type " + type.getCanonicalName(), e);
        }
    }
}

