/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.CascadeStrategy;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigLoader;
import com.netflix.archaius.api.ConfigReader;
import com.netflix.archaius.api.StrInterpolator;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.cascade.NoCascadeStrategy;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.interpolate.CommonsStrInterpolator;
import com.netflix.archaius.interpolate.ConfigStrLookup;
import com.netflix.archaius.readers.PropertiesConfigReader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigLoader
implements ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigLoader.class);
    private static final NoCascadeStrategy DEFAULT_CASCADE_STRATEGY = new NoCascadeStrategy();
    private static final StrInterpolator.Lookup DEFAULT_LOOKUP = new StrInterpolator.Lookup(){

        public String lookup(String key) {
            return null;
        }
    };
    private static final StrInterpolator DEFAULT_INTERPOLATOR = CommonsStrInterpolator.INSTANCE;
    private final Set<ConfigReader> loaders;
    private final CascadeStrategy defaultStrategy;
    private final StrInterpolator interpolator;
    private final StrInterpolator.Lookup lookup;

    public static Builder builder() {
        return new Builder();
    }

    public DefaultConfigLoader(Builder builder) {
        this.loaders = builder.loaders;
        this.defaultStrategy = builder.defaultStrategy;
        this.interpolator = builder.interpolator;
        this.lookup = builder.lookup;
    }

    public ConfigLoader.Loader newLoader() {
        return new ConfigLoader.Loader(){
            private CascadeStrategy strategy;
            private ClassLoader classLoader;
            private Config overrides;
            {
                this.strategy = DefaultConfigLoader.this.defaultStrategy;
                this.classLoader = Thread.currentThread().getContextClassLoader();
                this.overrides = null;
            }

            public ConfigLoader.Loader withCascadeStrategy(CascadeStrategy strategy) {
                this.strategy = strategy;
                return this;
            }

            public ConfigLoader.Loader withClassLoader(ClassLoader classLoader) {
                this.classLoader = classLoader;
                return this;
            }

            public ConfigLoader.Loader withFailOnFirst(boolean flag) {
                return this;
            }

            public ConfigLoader.Loader withOverrides(Properties props) {
                this.overrides = MapConfig.from(props);
                return this;
            }

            public ConfigLoader.Loader withOverrides(Config config) {
                this.overrides = config;
                return this;
            }

            public CompositeConfig load(String resourceName) throws ConfigException {
                DefaultCompositeConfig compositeConfig = new DefaultCompositeConfig(true);
                List names = this.strategy.generate(resourceName, DefaultConfigLoader.this.interpolator, DefaultConfigLoader.this.lookup);
                block2: for (String name : names) {
                    for (ConfigReader reader : DefaultConfigLoader.this.loaders) {
                        if (!reader.canLoad(this.classLoader, name)) continue;
                        try {
                            compositeConfig.addConfig(name, reader.load(this.classLoader, name, DefaultConfigLoader.this.interpolator, DefaultConfigLoader.this.lookup));
                            LOG.debug("Loaded {} ", (Object)name);
                        }
                        catch (ConfigException e) {
                            LOG.debug("Unable to load {}, {}", (Object)name, (Object)e.getMessage());
                        }
                        continue block2;
                    }
                }
                if (this.overrides != null) {
                    LOG.debug("Loading overrides form {}", (Object)resourceName);
                    compositeConfig.addConfig(resourceName + "_overrides", this.overrides);
                }
                return compositeConfig;
            }

            public Config load(URL url) {
                for (ConfigReader loader : DefaultConfigLoader.this.loaders) {
                    if (!loader.canLoad(this.classLoader, url)) continue;
                    try {
                        Config config = loader.load(this.classLoader, url, DefaultConfigLoader.this.interpolator, DefaultConfigLoader.this.lookup);
                        LOG.info("Loaded " + url);
                        return config;
                    }
                    catch (ConfigException e) {
                        LOG.info("Unable to load file '{}'", new Object[]{url, e.getMessage()});
                    }
                    catch (Exception e) {
                        LOG.info("Unable to load file '{}'", new Object[]{url, e.getMessage()});
                    }
                }
                return null;
            }

            public Config load(File file) throws ConfigException {
                try {
                    return this.load(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new ConfigException("Failed to load file " + file, (Throwable)e);
                }
            }
        };
    }

    static /* synthetic */ NoCascadeStrategy access$000() {
        return DEFAULT_CASCADE_STRATEGY;
    }

    static /* synthetic */ StrInterpolator access$100() {
        return DEFAULT_INTERPOLATOR;
    }

    static /* synthetic */ StrInterpolator.Lookup access$200() {
        return DEFAULT_LOOKUP;
    }

    public static class Builder {
        private Set<ConfigReader> loaders = new HashSet<ConfigReader>();
        private CascadeStrategy defaultStrategy = DefaultConfigLoader.access$000();
        private StrInterpolator interpolator = DefaultConfigLoader.access$100();
        private StrInterpolator.Lookup lookup = DefaultConfigLoader.access$200();

        public Builder withConfigReader(ConfigReader loader) {
            this.loaders.add(loader);
            return this;
        }

        public Builder withConfigReaders(Set<ConfigReader> loaders) {
            if (loaders != null) {
                this.loaders.addAll(loaders);
            }
            return this;
        }

        public Builder withDefaultCascadingStrategy(CascadeStrategy strategy) {
            if (strategy != null) {
                this.defaultStrategy = strategy;
            }
            return this;
        }

        @Deprecated
        public Builder withFailOnFirst(boolean flag) {
            return this;
        }

        public Builder withStrInterpolator(StrInterpolator interpolator) {
            if (interpolator != null) {
                this.interpolator = interpolator;
            }
            return this;
        }

        public Builder withStrLookup(StrInterpolator.Lookup lookup) {
            this.lookup = lookup;
            return this;
        }

        public Builder withStrLookup(Config config) {
            this.lookup = ConfigStrLookup.from(config);
            return this;
        }

        public DefaultConfigLoader build() {
            if (this.loaders.isEmpty()) {
                this.loaders.add(new PropertiesConfigReader());
            }
            return new DefaultConfigLoader(this);
        }
    }
}

