/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.AbstractProperty;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.DefaultPropertyFactory;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.api.annotations.Configuration;
import com.netflix.archaius.api.annotations.DefaultValue;
import com.netflix.archaius.api.annotations.PropertyName;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.commons.lang3.text.StrSubstitutor;

public class ConfigProxyFactory {
    private final Decoder decoder;
    private final PropertyFactory propertyFactory;
    private final Config config;

    @Inject
    public ConfigProxyFactory(Config config, Decoder decoder, PropertyFactory factory) {
        this.decoder = decoder;
        this.config = config;
        this.propertyFactory = factory;
    }

    public ConfigProxyFactory(Config config, PropertyFactory factory) {
        this(config, DefaultDecoder.INSTANCE, factory);
    }

    public ConfigProxyFactory(Config config) {
        this(config, DefaultPropertyFactory.from(config));
    }

    public <T> T newProxy(Class<T> type) {
        return this.newProxy(type, null);
    }

    private String derivePrefix(Configuration annot, String prefix) {
        if (prefix == null && annot != null && (prefix = annot.prefix()) == null) {
            prefix = "";
        }
        if (prefix == null) {
            return "";
        }
        if (prefix.endsWith(".") || prefix.isEmpty()) {
            return prefix;
        }
        return prefix + ".";
    }

    public <T> T newProxy(Class<T> type, String initialPrefix) {
        Configuration annot = type.getAnnotation(Configuration.class);
        return this.newProxy(type, initialPrefix, annot == null ? false : annot.immutable());
    }

    <T> T newProxy(final Class<T> type, String initialPrefix, boolean immutable) {
        Configuration annot = type.getAnnotation(Configuration.class);
        final String prefix = this.derivePrefix(annot, initialPrefix);
        final HashMap invokers = new HashMap();
        for (Method m : type.getMethods()) {
            String propName;
            String verb = m.getName().startsWith("get") ? "get" : (m.getName().startsWith("is") ? "is" : "");
            final DefaultValue defaultValue = m.getAnnotation(DefaultValue.class);
            final Class<?> returnType = m.getReturnType();
            final PropertyName nameAnnot = m.getAnnotation(PropertyName.class);
            String string = propName = nameAnnot != null && nameAnnot.name() != null ? prefix + nameAnnot.name() : prefix + Character.toLowerCase(m.getName().charAt(verb.length())) + m.getName().substring(verb.length() + 1);
            if (returnType.isInterface()) {
                invokers.put(m, this.createInterfaceProperty(propName, this.newProxy(returnType, propName, immutable)));
                continue;
            }
            if (m.getParameterTypes().length > 0) {
                invokers.put(m, new MethodInvoker(){

                    public Object invoke(Object[] args) {
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        for (int i = 0; i < args.length; ++i) {
                            values.put("" + i, args[i]);
                        }
                        String propName2 = new StrSubstitutor(values, "${", "}", '$').replace(nameAnnot.name());
                        return this.getPropertyWithDefault(returnType, propName2, defaultValue != null ? defaultValue.value() : null);
                    }

                    <R> R getPropertyWithDefault(Class<R> type, String propName2, String defaultValue2) {
                        return (R)ConfigProxyFactory.this.propertyFactory.getProperty(propName2).asType(type, ConfigProxyFactory.this.decoder.decode(type, defaultValue2)).get();
                    }

                    @Override
                    public String getKey() {
                        return propName;
                    }
                });
                continue;
            }
            if (immutable) {
                if (defaultValue != null) {
                    invokers.put(m, this.createImmutablePropertyWithDefault(m.getReturnType(), propName, defaultValue.value()));
                    continue;
                }
                invokers.put(m, this.createImmutablePropertyWithDefault(m.getReturnType(), propName, null));
                continue;
            }
            if (defaultValue != null) {
                invokers.put(m, this.createDynamicProperty(m.getReturnType(), propName, defaultValue.value()));
                continue;
            }
            invokers.put(m, this.createDynamicProperty(m.getReturnType(), propName, null));
        }
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                MethodInvoker invoker = (MethodInvoker)invokers.get(method);
                if (invoker != null) {
                    return invoker.invoke(args);
                }
                if ("toString".equals(method.getName())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(type.getSimpleName()).append("[");
                    Iterator iter = invokers.entrySet().iterator();
                    while (iter.hasNext()) {
                        MethodInvoker entry = (MethodInvoker)iter.next().getValue();
                        sb.append(entry.getKey().substring(prefix.length())).append("='");
                        try {
                            sb.append(entry.invoke(null));
                        }
                        catch (Exception e) {
                            sb.append(e.getMessage());
                        }
                        sb.append("'");
                        if (!iter.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("]");
                    return sb.toString();
                }
                throw new NoSuchMethodError(method.getName() + " not found on interface " + type.getName());
            }
        };
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
    }

    private <T> MethodInvoker<T> createImmutablePropertyWithDefault(final Class<T> type, final String propName, final String defaultValue) {
        return new PropertyMethodInvoker<T>(propName){
            private volatile T cached;

            public T get() {
                if (this.cached == null) {
                    this.cached = ConfigProxyFactory.this.propertyFactory.getProperty(propName).asType(type, ConfigProxyFactory.this.decoder.decode(type, defaultValue)).get();
                }
                return this.cached;
            }
        };
    }

    private <T> MethodInvoker<T> createInterfaceProperty(String propName, final T proxy) {
        return new PropertyMethodInvoker<T>(propName){

            public T get() {
                return proxy;
            }
        };
    }

    private <T> MethodInvoker<T> createDynamicProperty(Class<T> type, String propName, String defaultValue) {
        final Property prop = this.propertyFactory.getProperty(propName).asType(type, defaultValue != null ? this.decoder.decode(type, this.config.getString("*", defaultValue)) : null);
        return new MethodInvoker<T>(){

            @Override
            public T invoke(Object[] args) {
                return prop.get();
            }

            @Override
            public String getKey() {
                return prop.getKey();
            }
        };
    }

    private static abstract class PropertyMethodInvoker<T>
    extends AbstractProperty<T>
    implements MethodInvoker<T> {
        public PropertyMethodInvoker(String key) {
            super(key);
        }

        @Override
        public T invoke(Object[] args) {
            return (T)this.get();
        }
    }

    private static interface MethodInvoker<T> {
        public T invoke(Object[] var1);

        public String getKey();
    }
}

