/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.AbstractConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompositeConfig
extends AbstractConfig
implements CompositeConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompositeConfig.class);
    private final CopyOnWriteArrayList<Config> children = new CopyOnWriteArrayList();
    private final Map<String, Config> lookup = new LinkedHashMap<String, Config>();
    private final ConfigListener listener;
    private final boolean reversed;

    public static Builder builder() {
        return new Builder();
    }

    public static CompositeConfig create() throws ConfigException {
        return DefaultCompositeConfig.builder().build();
    }

    public DefaultCompositeConfig() {
        this(false);
    }

    public DefaultCompositeConfig(boolean reversed) {
        this.reversed = reversed;
        this.listener = new ConfigListener(){

            public void onConfigAdded(Config config) {
                DefaultCompositeConfig.this.notifyConfigAdded(DefaultCompositeConfig.this);
            }

            public void onConfigRemoved(Config config) {
                DefaultCompositeConfig.this.notifyConfigRemoved(DefaultCompositeConfig.this);
            }

            public void onConfigUpdated(Config config) {
                DefaultCompositeConfig.this.notifyConfigUpdated(DefaultCompositeConfig.this);
            }

            public void onError(Throwable error, Config config) {
                DefaultCompositeConfig.this.notifyError(error, DefaultCompositeConfig.this);
            }
        };
    }

    public synchronized boolean addConfig(String name, Config child) throws ConfigException {
        return this.internalAddConfig(name, child);
    }

    private synchronized boolean internalAddConfig(String name, Config child) throws ConfigException {
        LOG.trace("Adding config {} to {}", (Object)name, (Object)this.hashCode());
        if (child == null) {
            return false;
        }
        if (name == null) {
            throw new ConfigException("Child configuration must be named");
        }
        if (this.lookup.containsKey(name)) {
            LOG.info("Configuration with name'{}' already exists", (Object)name);
            return false;
        }
        this.lookup.put(name, child);
        if (this.reversed) {
            this.children.add(0, child);
        } else {
            this.children.add(child);
        }
        child.addListener(this.listener);
        this.postConfigAdded(child);
        return true;
    }

    public synchronized void addConfigs(LinkedHashMap<String, Config> configs) throws ConfigException {
        for (Map.Entry<String, Config> entry : configs.entrySet()) {
            this.internalAddConfig(entry.getKey(), entry.getValue());
        }
    }

    public void replaceConfigs(LinkedHashMap<String, Config> configs) throws ConfigException {
        for (Map.Entry<String, Config> entry : configs.entrySet()) {
            this.replaceConfig(entry.getKey(), entry.getValue());
        }
    }

    public synchronized Collection<String> getConfigNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.lookup.keySet());
        return result;
    }

    protected void postConfigAdded(Config child) {
        child.setStrInterpolator(this.getStrInterpolator());
        child.setDecoder(this.getDecoder());
        this.notifyConfigAdded(child);
        child.addListener(this.listener);
    }

    public synchronized void replaceConfig(String name, Config child) throws ConfigException {
        this.internalRemoveConfig(name);
        this.internalAddConfig(name, child);
    }

    public synchronized Config removeConfig(String name) {
        return this.internalRemoveConfig(name);
    }

    public synchronized Config internalRemoveConfig(String name) {
        Config child = this.lookup.remove(name);
        if (child != null) {
            this.children.remove(child);
            child.removeListener(this.listener);
            this.notifyConfigRemoved(child);
            return child;
        }
        return null;
    }

    public Config getConfig(String name) {
        return this.lookup.get(name);
    }

    public Object getRawProperty(String key) {
        for (Config child : this.children) {
            if (!child.containsKey(key)) continue;
            return child.getRawProperty(key);
        }
        return null;
    }

    @Override
    public <T> List<T> getList(String key, Class<T> type) {
        for (Config child : this.children) {
            if (!child.containsKey(key)) continue;
            return child.getList(key, type);
        }
        return (List)this.notFound(key);
    }

    @Override
    public List getList(String key) {
        for (Config child : this.children) {
            if (!child.containsKey(key)) continue;
            return child.getList(key);
        }
        return (List)this.notFound(key);
    }

    public boolean containsKey(String key) {
        for (Config child : this.children) {
            if (!child.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (Config child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterator<String> getKeys() {
        HashSet<String> result = new HashSet<String>();
        for (Config config : this.children) {
            Iterator iter = config.getKeys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                result.add(key);
            }
        }
        return result.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T> T accept(Config.Visitor<T> visitor) {
        Object result = null;
        if (visitor instanceof CompositeConfig.CompositeVisitor) {
            DefaultCompositeConfig defaultCompositeConfig = this;
            synchronized (defaultCompositeConfig) {
                CompositeConfig.CompositeVisitor cv = (CompositeConfig.CompositeVisitor)visitor;
                for (Map.Entry<String, Config> entry : this.lookup.entrySet()) {
                    result = cv.visitChild(entry.getKey(), entry.getValue());
                }
            }
        } else {
            for (Config child : this.children) {
                result = child.accept(visitor);
            }
        }
        return (T)result;
    }

    public static CompositeConfig from(LinkedHashMap<String, Config> load) throws ConfigException {
        Builder builder = DefaultCompositeConfig.builder();
        for (Map.Entry<String, Config> config : load.entrySet()) {
            builder.withConfig(config.getKey(), config.getValue());
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Config child : this.children) {
            sb.append(child.toString()).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Builder {
        LinkedHashMap<String, Config> configs = new LinkedHashMap();

        public Builder withConfig(String name, Config config) {
            this.configs.put(name, config);
            return this;
        }

        public CompositeConfig build() throws ConfigException {
            DefaultCompositeConfig config = new DefaultCompositeConfig();
            for (Map.Entry<String, Config> entry : this.configs.entrySet()) {
                config.addConfig(entry.getKey(), entry.getValue());
            }
            return config;
        }
    }
}

