/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.api.PropertyContainer;
import com.netflix.archaius.api.PropertyFactory;
import com.netflix.archaius.property.DefaultPropertyContainer;
import com.netflix.archaius.property.ListenerManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultPropertyFactory
implements PropertyFactory,
ConfigListener {
    private final Config config;
    private final ConcurrentMap<String, PropertyContainer> cache = new ConcurrentHashMap<String, PropertyContainer>();
    private final AtomicInteger version = new AtomicInteger();
    private final ListenerManager listeners = new ListenerManager();

    public static DefaultPropertyFactory from(Config config) {
        return new DefaultPropertyFactory(config);
    }

    public DefaultPropertyFactory(Config config) {
        this.config = config;
        this.config.addListener((ConfigListener)this);
    }

    public PropertyContainer getProperty(String propName) {
        PropertyContainer existing;
        PropertyContainer container = (PropertyContainer)this.cache.get(propName);
        if (container == null && (existing = this.cache.putIfAbsent(propName, container = new DefaultPropertyContainer(propName, this.config, this.version, this.listeners))) != null) {
            return existing;
        }
        return container;
    }

    public void onConfigAdded(Config config) {
        this.invalidate();
    }

    public void onConfigRemoved(Config config) {
        this.invalidate();
    }

    public void onConfigUpdated(Config config) {
        this.invalidate();
    }

    public void onError(Throwable error, Config config) {
    }

    public void invalidate() {
        this.version.incrementAndGet();
        this.listeners.updateAll();
    }
}

