/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ArchaiusType
implements ParameterizedType {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS;
    private final Class<?> rawType;
    private final Class<?>[] typeArguments;

    public static ParameterizedType forListOf(Class<?> listValuesType) {
        Class<?> maybeWrappedType = listValuesType.isPrimitive() ? PRIMITIVE_WRAPPERS.getOrDefault(listValuesType, listValuesType) : listValuesType;
        return new ArchaiusType(List.class, new Class[]{maybeWrappedType});
    }

    public static ParameterizedType forSetOf(Class<?> setValuesType) {
        Class<?> maybeWrappedType = setValuesType.isPrimitive() ? PRIMITIVE_WRAPPERS.getOrDefault(setValuesType, setValuesType) : setValuesType;
        return new ArchaiusType(Set.class, new Class[]{maybeWrappedType});
    }

    public static ParameterizedType forMapOf(Class<?> mapKeysType, Class<?> mapValuesType) {
        Class<?> maybeWrappedKeyType = mapKeysType.isPrimitive() ? PRIMITIVE_WRAPPERS.getOrDefault(mapKeysType, mapKeysType) : mapKeysType;
        Class<?> maybeWrappedValuesType = mapValuesType.isPrimitive() ? PRIMITIVE_WRAPPERS.getOrDefault(mapValuesType, mapValuesType) : mapValuesType;
        return new ArchaiusType(Map.class, new Class[]{maybeWrappedKeyType, maybeWrappedValuesType});
    }

    private ArchaiusType(Class<?> rawType, Class<?>[] typeArguments) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArguments = Objects.requireNonNull(typeArguments);
        if (rawType.isArray() || rawType.isPrimitive() || rawType.getTypeParameters().length != typeArguments.length) {
            throw new IllegalArgumentException("The provided rawType and arguments don't look like a supported parameterized type");
        }
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.rawType.getName());
        sb.append('<');
        boolean first = true;
        for (Class<?> t : this.typeArguments) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(t.getTypeName());
            first = false;
        }
        sb.append('>');
        return sb.toString();
    }

    public int hashCode() {
        return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        return other.getOwnerType() == null && Objects.equals(this.rawType, other.getRawType()) && Arrays.equals(this.typeArguments, other.getActualTypeArguments());
    }

    static {
        HashMap<Class<Object>, Class<Void>> wrappers = new HashMap<Class<Object>, Class<Void>>();
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Float.TYPE, Float.class);
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Void.TYPE, Void.class);
        PRIMITIVE_WRAPPERS = Collections.unmodifiableMap(wrappers);
    }
}

