/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class URLConfigurationSource
implements PolledConfigurationSource {
    private final URL[] configUrls;
    public static final String CONFIG_URL = "archaius.configurationSource.additionalUrls";
    public static final String DEFAULT_CONFIG_FILE_NAME = "config.properties";
    public static final String DEFAULT_CONFIG_FILE_FROM_CLASSPATH = System.getProperty("archaius.configurationSource.defaultFileName") == null ? "config.properties" : System.getProperty("archaius.configurationSource.defaultFileName");

    public URLConfigurationSource(String ... stringArray) {
        this.configUrls = URLConfigurationSource.createUrls(stringArray);
    }

    private static URL[] createUrls(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("urlStrings is null or empty");
        }
        URL[] uRLArray = new URL[stringArray.length];
        try {
            for (int i = 0; i < uRLArray.length; ++i) {
                uRLArray[i] = new URL(stringArray[i]);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return uRLArray;
    }

    public URLConfigurationSource(URL ... uRLArray) {
        this.configUrls = uRLArray;
    }

    public URLConfigurationSource() {
        String[] stringArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL uRL = this.getConfigFileFromClasspath();
        if (uRL != null) {
            arrayList.add(uRL);
        }
        if ((stringArray = URLConfigurationSource.getDefaultFileSources()).length != 0) {
            arrayList.addAll(Arrays.asList(URLConfigurationSource.createUrls(stringArray)));
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("System property archaius.configurationSource.additionalUrls is undefined and default configuration file " + DEFAULT_CONFIG_FILE_FROM_CLASSPATH + " cannot be found on classpath. At least one of them has to be supplied.");
        }
        this.configUrls = arrayList.toArray(new URL[arrayList.size()]);
    }

    private URL getConfigFileFromClasspath() {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            uRL = classLoader.getResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        if (uRL == null) {
            uRL = URLConfigurationSource.class.getResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        return uRL;
    }

    private static final String[] getDefaultFileSources() {
        String string = System.getProperty(CONFIG_URL);
        String[] stringArray = string != null ? string.split(",") : new String[]{};
        return stringArray;
    }

    @Override
    public PollResult poll(boolean bl, Object object) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (URL uRL : this.configUrls) {
            Properties properties = new Properties();
            InputStream inputStream = uRL.openStream();
            properties.load(inputStream);
            inputStream.close();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        return PollResult.createFull(hashMap);
    }

    public String toString() {
        return "FileConfigurationSource [fileUrls=" + Arrays.toString(this.configUrls) + "]";
    }
}

