/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.util.Log;
import android.util.Pair;
import com.netease.nis.bugrpt.CrashHandler;
import com.netease.nis.bugrpt.user.AbstractNetClient;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    private static final String HOSTURL = "https://crash.163.com";
    public static int TIMEOUT_VAL = 1500;
    private static final String mProtocolVersion = "1.0.1";
    private static int MAX_RETRIES = 3;

    private static String getCrashUploadUrl() {
        String path = "https://crash.163.com/uploadCrashLogInfo.do";
        Log.d((String)"bugrpt", (String)("url:" + path));
        return path;
    }

    private static String getInitUploadUrl() {
        String path = "https://crash.163.com/client/api/uploadStartUpInfo.do";
        Log.d((String)"bugrpt", (String)("url:" + path));
        return path;
    }

    public static String getProtocolHeaderData(String appid, boolean isEncoded) {
        String strHeaderData = "";
        JSONObject params = new JSONObject();
        try {
            params.put("version", (Object)mProtocolVersion);
            params.put("appid", (Object)appid);
            long timestamp = System.currentTimeMillis();
            params.put("uploadtime", timestamp);
            if (isEncoded) {
                params.put("isencoded", (Object)"1");
            } else {
                params.put("isencoded", (Object)"0");
            }
            strHeaderData = params.toString();
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return strHeaderData;
    }

    public static boolean send(String uploadText, DataType dataType, boolean bAsyn) {
        String url;
        boolean bRet = false;
        if (uploadText == null || uploadText.equals("")) {
            return bRet;
        }
        switch (dataType) {
            case CRASHINFO_UPLOAD: {
                url = HttpUtil.getCrashUploadUrl();
                break;
            }
            case INITINFO_UPLOAD: {
                url = HttpUtil.getInitUploadUrl();
                break;
            }
            default: {
                url = HttpUtil.getCrashUploadUrl();
            }
        }
        try {
            AbstractNetClient client = CrashHandler.getNetClient();
            if (client != null) {
                Pair<Integer, String> pair = client.send(url, uploadText, HttpUtil.getTimeOut(bAsyn));
                if (pair != null) {
                    if ((Integer)pair.first == 200) {
                        bRet = true;
                        Log.d((String)"bugrpt", (String)"send success");
                    } else {
                        Log.d((String)"bugrpt", (String)("send failed! response code:" + pair.first + " message:" + (String)pair.second));
                    }
                }
            } else {
                Log.d((String)"bugrpt", (String)"NetClient is null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bRet;
    }

    public static String fmtPostData(Map<String, String> params, String encoding) {
        String entity = "";
        try {
            StringBuilder data = new StringBuilder();
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    data.append(entry.getKey()).append("=");
                    String strValue = entry.getValue();
                    if (strValue == null) {
                        strValue = "";
                    }
                    data.append(URLEncoder.encode(strValue, encoding));
                    data.append("&");
                }
                data.deleteCharAt(data.length() - 1);
            }
            entity = data.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entity;
    }

    public static int getSynSendWaitTime() {
        return TIMEOUT_VAL * 2 + 500;
    }

    public static int getTimeOut(boolean bIdel) {
        if (bIdel) {
            return TIMEOUT_VAL * 3;
        }
        return TIMEOUT_VAL;
    }

    public static enum DataType {
        CRASHINFO_UPLOAD,
        INITINFO_UPLOAD;

    }
}

