/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.tool;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AppInfo {
    public static String getChannelFromXml(Context ctx, String channelKey) {
        String strChannel = "";
        try {
            Object bundle;
            ApplicationInfo appInfo;
            if (ctx != null && (appInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128)) != null && appInfo.metaData != null && (bundle = appInfo.metaData.get(channelKey)) != null && (strChannel = bundle.toString()).length() > 100) {
                strChannel = strChannel.substring(0, 100);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strChannel;
    }

    public String getFileHash(Context ctx) {
        String fileHash = "";
        try {
            ZipFile zf = new ZipFile(this.getApkFilePath(ctx));
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String name = ze.getName();
                if (name.compareTo("META-INF/MANIFEST.MF") != 0) continue;
                fileHash = String.format("%08X", ze.getCrc());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileHash;
    }

    public String getApplicationName(Context ctx) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        String applicationName = "";
        try {
            packageManager = ctx.getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(ctx.getPackageName(), 0);
            if (applicationInfo != null) {
                applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return applicationName;
    }

    public String getVersionName(Context ctx) {
        String version = "";
        try {
            PackageManager packageManager = ctx.getPackageManager();
            PackageInfo pkgInfo = packageManager.getPackageInfo(ctx.getPackageName(), 0);
            version = pkgInfo.versionName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private String getApkFilePath(Context ctx) {
        String filePath = "";
        PackageManager packageManager = ctx.getPackageManager();
        try {
            filePath = packageManager.getPackageInfo((String)ctx.getPackageName(), (int)0).applicationInfo.sourceDir;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filePath;
    }

    public String getAppID(Context ctx) {
        String App_UID = "";
        try {
            Object bundle;
            ApplicationInfo appInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            if (appInfo != null && appInfo.metaData != null && (bundle = appInfo.metaData.get("BUGRPT_APPID")) != null && (App_UID = bundle.toString()).length() > 100) {
                App_UID = App_UID.substring(0, 100);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return App_UID;
    }
}

