/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt.crash;

import android.content.Context;
import android.util.Log;
import com.netease.nis.bugrpt.CrashHandler;
import com.netease.nis.bugrpt.crash.CrashDetailBean;
import com.netease.nis.bugrpt.tool.AppInfo;
import com.netease.nis.bugrpt.tool.CacheHelper;
import com.netease.nis.bugrpt.tool.Common;
import com.netease.nis.bugrpt.tool.DeviceInfo;
import com.netease.nis.bugrpt.tool.HttpUtil;
import com.netease.nis.bugrpt.tool.SharedPrefUtil;
import com.netease.nis.bugrpt.user.UserStrategy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashHandleThread
extends Thread
implements Runnable {
    private LinkedList<String> mCacheItemList = new LinkedList();
    private CrashDetailBean mBean = null;
    private UserStrategy mUserStrategy = null;
    private Context mContext = null;
    private JSONObject mVersion = new JSONObject();
    private String mCacheDir = "";
    private boolean mNeedCache = true;
    private String mPostData = "";
    private boolean mbIdel = true;
    private static ReentrantLock mLock = new ReentrantLock();

    public CrashHandleThread(CrashDetailBean bean) {
        this.mBean = bean;
    }

    public synchronized void flush() {
        if (this.mNeedCache && !this.mPostData.equals("")) {
            this.mNeedCache = !CacheHelper.getInstance().writeCrashLog(this.mPostData, this.mCacheDir);
        }
    }

    public CrashHandleThread setIdel(boolean bIdel) {
        this.mbIdel = bIdel;
        return this;
    }

    public CrashHandleThread setContext(Context ctx) {
        this.mContext = ctx;
        return this;
    }

    public CrashHandleThread setUserStrategy(UserStrategy userStrategy) {
        this.mUserStrategy = userStrategy;
        return this;
    }

    public CrashHandleThread setCacheDir(String cacheDir) {
        this.mCacheDir = cacheDir;
        return this;
    }

    public CrashHandleThread setSdkVersion(JSONObject version) {
        this.mVersion = version;
        return this;
    }

    @Override
    public void run() {
        mLock.lock();
        try {
            SharedPrefUtil sharedUtil = new SharedPrefUtil(this.mContext);
            if (!sharedUtil.isReachLimitCount(this.mBean)) {
                Log.d((String)"bugrpt", (String)(Thread.currentThread().getName() + " is runing"));
                this.mPostData = this.getCrashInfoPostData(this.mBean, true);
                boolean bRet = HttpUtil.send(this.mPostData, HttpUtil.DataType.CRASHINFO_UPLOAD, this.mbIdel);
                if (!bRet) {
                    Log.d((String)"bugrpt", (String)"Thread send failed");
                    this.flush();
                } else {
                    this.mNeedCache = false;
                    Log.d((String)"bugrpt", (String)"Thread send success");
                    sharedUtil.increaseCrashSendCount(this.mBean);
                }
            } else {
                Log.d((String)"bugrpt", (String)"Already reached limited count");
            }
        }
        catch (Exception e) {
            Log.d((String)"bugrpt", (String)"Exception in thread");
            e.printStackTrace();
        }
        finally {
            mLock.unlock();
        }
    }

    private JSONObject getCrashExtendsInfo(Context ctx, CrashDetailBean bean) {
        JSONObject jsonObject = new JSONObject();
        try {
            JSONArray threadStack = bean.getAllThreadStack();
            jsonObject.put("ThreadInfo", (Object)threadStack);
            String sysLog = bean.getSysLog(ctx);
            jsonObject.put("Syslog", (Object)sysLog);
            String anrMsg = bean.getAnrMsg();
            jsonObject.put("AnrMessage", (Object)anrMsg);
            JSONArray anrTrace = bean.getAnrTraceInfo();
            jsonObject.put("AnrTrace", (Object)anrTrace);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject;
    }

    private String getChannelInternal(Context ctx) {
        String[] channelKeyList = new String[]{"UMENG_CHANNEL", "TD_CHANNEL_ID", "CHANNEL"};
        String channel = "";
        for (String channelKey : channelKeyList) {
            String channelFromXml = AppInfo.getChannelFromXml(ctx, channelKey);
            if (Common.isNullOrNil(channelFromXml)) continue;
            channel = channelFromXml;
            break;
        }
        return channel;
    }

    private JSONObject getUserExtraInfo(Context ctx) {
        String channel = "";
        String userId = "";
        String userTag = "";
        String scene = "";
        String trackLog = "";
        if (this.mUserStrategy != null) {
            channel = this.mUserStrategy.getChannel();
            userId = this.mUserStrategy.getUserId();
            userTag = this.mUserStrategy.getUserTag();
            scene = this.mUserStrategy.getScene();
            trackLog = this.mUserStrategy.getTrackLog();
        }
        if (Common.isNullOrNil(channel)) {
            channel = this.getChannelInternal(ctx);
        }
        Log.d((String)"bugrpt", (String)("channel:" + channel));
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("Channel", (Object)channel);
            jsonObject.put("UserId", (Object)userId);
            jsonObject.put("UserTag", (Object)userTag);
            jsonObject.put("Scene", (Object)scene);
            jsonObject.put("UserLog", (Object)trackLog);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject;
    }

    private JSONObject getUserParam() {
        JSONObject userParam = new JSONObject();
        if (this.mUserStrategy != null) {
            userParam = this.mUserStrategy.getUserDefineParam();
        }
        return userParam;
    }

    private String getCrashInfoData(CrashDetailBean bean, boolean bEncoded) {
        String strCrashInfoData = "";
        JSONObject params = new JSONObject();
        try {
            Context ctx = this.mContext;
            AppInfo appInfo = new AppInfo();
            String appName = appInfo.getApplicationName(ctx);
            String versionName = this.mUserStrategy.getAppVersion(ctx);
            String packageName = ctx.getPackageName();
            String crashInfo = Common.truncateUserInput(bean.getCrashInfo(), 98304);
            params.put("crashinfo", (Object)crashInfo);
            params.put("appname", (Object)appName);
            params.put("version", (Object)versionName);
            params.put("packagename", (Object)packageName);
            String strPlatformTag = bean.getPlatformTag();
            Log.d((String)"bugrpt", (String)("platform tag:" + strPlatformTag));
            params.put("tag", (Object)strPlatformTag);
            String strExceptionType = bean.getExceptionType();
            Log.d((String)"bugrpt", (String)("type:" + strExceptionType));
            params.put("exceptiontype", (Object)strExceptionType);
            JSONObject crashExtendsInfo = this.getCrashExtendsInfo(ctx, bean);
            params.put("crashinfoExtends", (Object)crashExtendsInfo);
            JSONObject mechineInfo = DeviceInfo.collectDeviceInfo(ctx, CrashHandler.getInstance().getStartTime());
            params.put("machineInfo", (Object)mechineInfo);
            this.flushSelfTrack(crashInfo);
            JSONObject extraInfo = this.getUserExtraInfo(ctx);
            params.put("extraInfo", (Object)extraInfo);
            JSONObject userParam = this.getUserParam();
            params.put("userParam", (Object)userParam);
            JSONObject sdkversion = this.getFmtSdkVersion();
            params.put("sdkversion", (Object)sdkversion);
            strCrashInfoData = bEncoded ? Common.encryptData(params.toString()) : params.toString();
        }
        catch (Exception e) {
            Log.d((String)"bugrpt", (String)"exception in getCrashInfoData");
        }
        return strCrashInfoData;
    }

    private String getCrashInfoPostData(CrashDetailBean bean, boolean bEncrypt) {
        String postData = "";
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String appID = this.mUserStrategy.getAppID(this.mContext);
            String head = HttpUtil.getProtocolHeaderData(appID, bEncrypt);
            params.put("head", head);
            this.addSelfTrack("head:" + head.length());
            boolean bRet = false;
            String crashData = this.getCrashInfoData(bean, bEncrypt);
            if (!crashData.equals("")) {
                params.put("data", crashData);
                bRet = true;
                this.addSelfTrack("data:" + crashData.length());
            }
            if (bRet) {
                postData = HttpUtil.fmtPostData(params, "UTF-8");
            }
        }
        catch (Exception e) {
            Log.d((String)"bugrpt", (String)"exception in getCrashInfoPostData");
        }
        return postData;
    }

    public JSONObject getFmtSdkVersion() {
        JSONObject fmtVersion = new JSONObject();
        Iterator keys = this.mVersion.keys();
        try {
            while (keys.hasNext()) {
                String entry = (String)keys.next();
                Object val = this.mVersion.get(entry);
                if (val instanceof String) {
                    String version = (String)val;
                    fmtVersion.put(entry, (Object)(entry + ":" + version));
                    continue;
                }
                Log.d((String)"bugrpt", (String)"Unknown sdk version type");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return fmtVersion;
    }

    private void addSelfTrack(String Item) {
        try {
            if (this.mCacheItemList != null) {
                this.mCacheItemList.add(Item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void flushSelfTrack(String crashInfo) {
        try {
            if (crashInfo.contains("java.lang.OutOfMemoryError") && crashInfo.contains("bugrpt")) {
                for (String o : this.mCacheItemList) {
                    CrashHandler.leaveBreadcrumb(o);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

