/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nis.bugrpt;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.netease.nis.bugrpt.NativeCrashHandler;
import com.netease.nis.bugrpt.crash.CrashDetailBean;
import com.netease.nis.bugrpt.crash.CrashHandleThread;
import com.netease.nis.bugrpt.crash.JS.H5JavaScriptInterface;
import com.netease.nis.bugrpt.crash.JS.JsConstant;
import com.netease.nis.bugrpt.crash.anr.AnrMonitor;
import com.netease.nis.bugrpt.init.ActivityStatusMonitor;
import com.netease.nis.bugrpt.init.InitTask;
import com.netease.nis.bugrpt.tool.AESCrypt;
import com.netease.nis.bugrpt.tool.CacheHelper;
import com.netease.nis.bugrpt.tool.Common;
import com.netease.nis.bugrpt.tool.DefaultHttpClient;
import com.netease.nis.bugrpt.tool.HttpUtil;
import com.netease.nis.bugrpt.tool.WrapperUtil;
import com.netease.nis.bugrpt.user.AbstractNetClient;
import com.netease.nis.bugrpt.user.UserStrategy;
import java.io.File;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "bugrpt";
    public static final String VER = "4.1";
    private static CrashHandler INSTANCE;
    private static UserStrategy mUserStrategy;
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private Context mContext = null;
    private JSONObject mVersion = new JSONObject();
    private long mStartTime = 0L;
    private String mCrashLogDir = "";
    private boolean mbInit = false;
    private ExecutorService service = Executors.newCachedThreadPool();
    private ScheduledExecutorService scheduledExecutorService = null;
    ActivityStatusMonitor activityStatusMonitor = null;
    private AnrMonitor mAnrMonitor = null;
    private static AbstractNetClient mNetClient;
    private static String mWebView;

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CrashHandler();
        }
        return INSTANCE;
    }

    public static void init(Context context) {
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null) {
            inst.init(context, null, "");
        }
    }

    public static void agentInit(Context activityCtx, String appid, String sdkVersion, String platformTag) {
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null) {
            Context appCtx = activityCtx.getApplicationContext();
            UserStrategy customStrategy = new UserStrategy(appCtx);
            if (appid != "") {
                customStrategy.setAppId(appid);
                Log.d((String)TAG, (String)("[agentInit] appid:" + appid));
            }
            if (platformTag.startsWith("u3d")) {
                inst.addSdkVersion("u3d", sdkVersion);
            } else {
                inst.addSdkVersion(platformTag, sdkVersion);
            }
            Log.d((String)TAG, (String)("[agentInit] sdkVersion:" + sdkVersion));
            Log.d((String)TAG, (String)("[agentInit] platformTag:" + platformTag));
            inst.init(appCtx, customStrategy, "");
        }
    }

    public static void init(Context context, UserStrategy customStrategy) {
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null) {
            inst.init(context, customStrategy, "");
        }
    }

    public void init(Context context, UserStrategy customStrategy, String reserved) {
        if (this.mbInit) {
            return;
        }
        this.mContext = context;
        mUserStrategy = customStrategy != null ? customStrategy : new UserStrategy(this.mContext);
        this.addSdkVersion("java", VER);
        String wrapperversion = WrapperUtil.ReinvokeWrapperVersion(this.getClass().getName());
        mUserStrategy.setUserTag(wrapperversion);
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        boolean bBugrptExists = WrapperUtil.isBugrptAlreadyStarted(this.getClass().getName());
        if (!bBugrptExists && mUserStrategy.isNdkCrashMonitored()) {
            int nStart;
            String strNativeVer = NativeCrashHandler.initNative(context);
            if (strNativeVer != null && strNativeVer.length() > 0 && (nStart = strNativeVer.indexOf("(")) != -1) {
                int nEnd = strNativeVer.indexOf(")", nStart);
                if (nEnd != -1) {
                    String abi = strNativeVer.substring(nStart + 1, nEnd);
                    Log.d((String)TAG, (String)("libbugrpt.so abi:" + abi));
                }
                String ndkversion = strNativeVer.substring(0, nStart - 1);
                this.addSdkVersion("ndk", ndkversion);
            }
        } else {
            Log.d((String)TAG, (String)"native init cancel.");
        }
        this.mStartTime = System.currentTimeMillis();
        this.setCacheDir();
        if (mUserStrategy.isAnrMonitored()) {
            this.mAnrMonitor = new AnrMonitor(this.mContext);
            this.mAnrMonitor.startMonitorANR();
        }
        CrashHandler.setNetClient(new DefaultHttpClient());
        this.startInitTask();
        if (Common.isNetworkAvailable(this.mContext)) {
            CacheHelper.getInstance().checkCrashLog(this.mCrashLogDir);
        }
        this.mbInit = true;
    }

    private void startInitTask() {
        InitTask task = new InitTask(this.mContext).setSdkVersion(this.mVersion).setUserStrategy(mUserStrategy);
        if (Common.isInMidNight()) {
            this.delayInitTask(task);
        } else {
            this.service.execute(task);
        }
    }

    private void delayInitTask(final InitTask task) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(2);
        }
        if (this.activityStatusMonitor == null) {
            this.activityStatusMonitor = new ActivityStatusMonitor(this.mContext);
        }
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                if (CrashHandler.this.activityStatusMonitor.isAppBackground()) {
                    Random random = new Random();
                    int delayTime = random.nextInt(300);
                    CrashHandler.this.scheduledExecutorService.schedule(task, (long)(delayTime * 1000), TimeUnit.MILLISECONDS);
                } else {
                    CrashHandler.this.scheduledExecutorService.schedule(task, 500L, TimeUnit.MILLISECONDS);
                }
                CrashHandler.this.activityStatusMonitor.unregisterActiLifeCallbacks(CrashHandler.this.mContext);
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    private void setCacheDir() {
        try {
            File f = this.mContext.getFilesDir();
            if (f != null) {
                File crashLogDir = new File(f, "crashlog");
                this.mCrashLogDir = crashLogDir.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setNetClient(AbstractNetClient netClient) {
        if (netClient != null) {
            mNetClient = netClient;
        }
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean autoInject) {
        return CrashHandler.setJavascriptMonitor(webView, autoInject, false);
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean autoInject, boolean force) {
        if (webView.getUrl() == null) {
            return false;
        }
        if (mWebView != null && mWebView.equals(webView.getUrl())) {
            return true;
        }
        mWebView = webView.getUrl();
        if (!force && Build.VERSION.SDK_INT < 19) {
            Log.e((String)TAG, (String)"This interface is only available for Android 4.4 or later.");
            return false;
        }
        Log.d((String)TAG, (String)"Set webview monitor.");
        WebSettings settings = webView.getSettings();
        if (!settings.getJavaScriptEnabled()) {
            settings.setJavaScriptEnabled(true);
            Log.d((String)TAG, (String)"Enable the javascript needed by webview monitor.");
        }
        H5JavaScriptInterface h5instance = H5JavaScriptInterface.getInstance(webView);
        String bugrptjs = JsConstant.ENCRYPT_JSCODE;
        if (h5instance != null) {
            webView.addJavascriptInterface((Object)h5instance, "exceptionUploader");
            Log.d((String)TAG, (String)"addJavascriptInterface exceptionUploader");
        }
        if (autoInject) {
            String bugrptJs = CrashHandler.decryptJS(bugrptjs);
            webView.loadUrl("javascript:" + bugrptJs);
            Log.d((String)TAG, (String)("Inject bugrpt.js to the webview:" + bugrptJs));
        }
        return true;
    }

    private static String decryptJS(String bugrptjs) {
        String oriBugrptjs = "";
        try {
            String orpes = JsConstant.ENCRYPT_KEY;
            oriBugrptjs = AESCrypt.decrypt(AESCrypt.decryptStr(orpes), bugrptjs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oriBugrptjs;
    }

    public static boolean sendReportsBridge(String info, String tag) {
        Log.d((String)TAG, (String)("sendReportsBridge:" + info));
        boolean bret = false;
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null) {
            String realTag = tag;
            String version = "";
            int index = tag.indexOf("&");
            if (index != -1) {
                realTag = tag.substring(0, index);
                version = tag.substring(index + 1);
                if (realTag.contains("u3d")) {
                    inst.addSdkVersion("u3d", version);
                } else {
                    inst.addSdkVersion(realTag, version);
                }
            }
            Log.d((String)TAG, (String)("sendReportsBridge tag:" + realTag + " version:" + version));
            bret = inst.asySendReportToServer(info, realTag, "exception");
        }
        return bret;
    }

    public static void setUserTrackLog(String trackLog) {
        if (mUserStrategy == null) {
            return;
        }
        mUserStrategy.appendTrackLog(trackLog);
    }

    public static void leaveBreadcrumb(String info) {
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null) {
            inst.trackBreadcrumb(info);
        }
    }

    public static void uploadUserDefineLog(String customException, String logContent) {
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null && customException != null && logContent != null) {
            if (customException.length() > 50 || customException.length() == 0) {
                return;
            }
            logContent = Common.truncateUserInput(logContent, 10240);
            StringBuffer uploadsb = new StringBuffer();
            uploadsb.append("name=").append(customException);
            uploadsb.append("\ncomment=this is a user-defined exception\n");
            uploadsb.append("\ncallstack=\n");
            uploadsb.append(logContent);
            inst.asySendReportToServer(uploadsb.toString(), "java", "userlog");
        }
    }

    public static void uploadTrackRecord(String info) {
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null && info != null) {
            info = Common.truncateUserInput(info, 10240);
            StringBuffer uploadsb = new StringBuffer();
            uploadsb.append("User Track Record\nCheck for detail\nLength:");
            uploadsb.append(info.length());
            uploadsb.append("\nTrack record:").append(info).append("\n\nCurrent stack trace:\n");
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            for (int i = 2; i < st.length; ++i) {
                String stackInfo = st[i].toString();
                if (stackInfo.contains(TAG)) continue;
                uploadsb.append("\t");
                uploadsb.append(stackInfo);
                uploadsb.append("\n");
            }
            inst.asySendReportToServer(uploadsb.toString(), "java", "userlog");
        }
    }

    public static void uploadCatchedException(Throwable thr) {
        String info;
        CrashHandler inst = CrashHandler.getInstance();
        if (inst != null && (info = Common.exceptionToString(thr)) != null && info.compareTo("") != 0) {
            inst.asySendReportToServer(info, "java", "catchedexception");
        }
    }

    public static void setUserScene(String scene) {
        if (mUserStrategy != null) {
            mUserStrategy.setScene(scene);
        }
    }

    public static void setUserTag(String tag) {
        if (mUserStrategy != null) {
            mUserStrategy.setUserTag(tag);
        }
    }

    public static void setUserId(String userId) {
        if (mUserStrategy != null) {
            mUserStrategy.setUserId(userId);
        }
    }

    public static void addUserParam(String key, String val) {
        if (mUserStrategy != null) {
            mUserStrategy.addUserDefinedParam(key, val);
        }
    }

    public static void addUserParam(Map<String, String> map) {
        if (mUserStrategy != null && map != null) {
            Map<String, String> userParamMap = map;
            for (Map.Entry<String, String> entry : userParamMap.entrySet()) {
                mUserStrategy.addUserDefinedParam(entry.getKey(), entry.getValue());
            }
        }
    }

    private void addSdkVersion(String tag, String version) {
        if (tag.equals("") || version.equals("")) {
            return;
        }
        try {
            this.mVersion.put(tag, (Object)version);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.handleException(ex);
        try {
            mUserStrategy.dealUserUncaughtExceptionCallback(thread, ex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            this.mContext.startActivity(intent);
            Process.killProcess((int)Process.myPid());
            ((ActivityManager)this.mContext.getSystemService("activity")).killBackgroundProcesses(this.mContext.getPackageName());
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        String crashInfo = Common.exceptionToString(ex);
        String exceptionDesc = ex.toString();
        Log.d((String)TAG, (String)("handleException " + exceptionDesc));
        this.sendReportsToServer(crashInfo, "java");
        return true;
    }

    public boolean sendReportsToServer(String text, String tag) {
        if (tag != null) {
            Log.d((String)TAG, (String)("sendReportsToServer begin,tag:" + tag));
        }
        if (this.mContext == null) {
            Log.d((String)TAG, (String)"ctx is null");
            return false;
        }
        try {
            CrashDetailBean bean = new CrashDetailBean(text).setPlatformTag(tag).setExceptionType("exception");
            CrashHandleThread crashHandleThread = new CrashHandleThread(bean).setIdel(false).setUserStrategy(mUserStrategy).setCacheDir(this.mCrashLogDir).setContext(this.mContext).setSdkVersion(this.mVersion);
            crashHandleThread.start();
            crashHandleThread.join(HttpUtil.getSynSendWaitTime());
            crashHandleThread.flush();
            Log.d((String)TAG, (String)"sendReportsToServer end");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean sendReportsToServer(String text) {
        return this.sendReportsToServer(text, null);
    }

    public boolean asySendReportToServer(CrashDetailBean bean) {
        boolean bret = false;
        Log.d((String)TAG, (String)"asySendReportToServer begin");
        if (this.mContext == null) {
            Log.d((String)TAG, (String)"ctx is null");
            return bret;
        }
        CrashHandleThread crashHandleThread = new CrashHandleThread(bean).setIdel(true).setUserStrategy(mUserStrategy).setCacheDir(this.mCrashLogDir).setContext(this.mContext).setSdkVersion(this.mVersion);
        this.service.execute(crashHandleThread);
        bret = true;
        Log.d((String)TAG, (String)"asySendReportToServer end");
        return bret;
    }

    protected boolean asySendReportToServer(String text, String tag, String exceptType) {
        CrashDetailBean bean = new CrashDetailBean(text).setPlatformTag(tag).setExceptionType(exceptType);
        return this.asySendReportToServer(bean);
    }

    public void trackBreadcrumb(String info) {
        if (info == null || mUserStrategy == null) {
            return;
        }
        mUserStrategy.appendTrackLog(info);
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public static AbstractNetClient getNetClient() {
        return mNetClient;
    }

    static {
        mUserStrategy = null;
        mNetClient = null;
        mWebView = null;
    }
}

