/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.log.sdk.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtils {
    private static final String TAG = "FileUtils";

    public static File getFile(String string) {
        try {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 == null) {
                Log.e((String)TAG, (String)("file's parent dir is null, path=" + file.getCanonicalPath()));
                return null;
            }
            if (!file2.exists()) {
                if (file2.getParentFile().exists()) {
                    file2.mkdir();
                } else {
                    file2.mkdirs();
                }
            }
            if (!file.exists() && !file.createNewFile()) {
                Log.e((String)TAG, (String)("can not create dest file, path=" + string));
                return null;
            }
            return file;
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)("create dest file error, path=" + string), (Throwable)throwable);
            return null;
        }
    }

    public static boolean appendFile(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        boolean bl = false;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2, true));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean appendFile(byte[] byArray, String string) {
        if (byArray == null || byArray.length <= 0) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shrink(String string, int n, int n2) {
        File file = new File(string);
        if (file.length() < (long)n) {
            return;
        }
        if (file.length() > Integer.MAX_VALUE) {
            file.delete();
            return;
        }
        File file2 = new File(string + "_tmp");
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            FileChannel fileChannel = fileInputStream.getChannel();
            fileChannel.position(file.length() - (long)n2);
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            fileChannel2.transferFrom(fileInputStream.getChannel(), 0L, n2);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.close(fileInputStream);
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileInputStream);
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileInputStream);
        FileUtils.close(fileOutputStream);
        if (file2.exists() && file.delete()) {
            file2.renameTo(file);
        }
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getFilePath(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            if (file.getParentFile().exists()) {
                file.mkdir();
            } else {
                file.mkdirs();
            }
        }
        return string + File.separator + string2;
    }

    public static boolean hasExtension(String string) {
        int n = string.lastIndexOf(46);
        return n > -1 && n < string.length() - 1;
    }

    public static String getExtensionName(String string) {
        int n;
        if (string != null && string.length() > 0 && (n = string.lastIndexOf(46)) > -1 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String getFileNameFromPath(String string) {
        int n;
        if (string != null && string.length() > 0 && (n = string.lastIndexOf(47)) > -1 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getFileNameNoEx(String string) {
        int n;
        if (string != null && string.length() > 0 && (n = string.lastIndexOf(46)) > -1 && n < string.length()) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExternalPackageDirectory(Context context) {
        String string = Environment.getExternalStorageDirectory().getPath();
        return string + File.separator + context.getPackageName();
    }
}

