/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.log.sdk;

import android.text.TextUtils;
import android.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

class LogFormat {
    private static final String MESSAGE_FORMAT = "MM-dd HH:mm:ss.SSS";
    private static final DateFormat messageFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private static final Date date = new Date();
    private static long lastTime;
    private static String lastTimeStr;
    private static final String SUFFIX = ".log";
    private static final String FILE_FORMAT = "yyyyMMdd";
    private static final DateFormat fileNameFormat;

    LogFormat() {
    }

    static String formatTime(long l) {
        if (l == lastTime) {
            return lastTimeStr;
        }
        date.setTime(l);
        lastTime = l;
        lastTimeStr = messageFormat.format(date);
        return lastTimeStr;
    }

    static String formatLog(String string, String string2, String string3, Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(": ");
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string3);
        stringBuilder.append("\r\n");
        if (throwable != null) {
            stringBuilder.append(Log.getStackTraceString((Throwable)throwable));
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    static String getLogFileName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            stringBuilder.append("_");
        }
        stringBuilder.append(fileNameFormat.format(new Date()));
        stringBuilder.append(SUFFIX);
        return stringBuilder.toString();
    }

    static {
        fileNameFormat = new SimpleDateFormat(FILE_FORMAT, Locale.getDefault());
    }
}

