/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.log.sdk;

import android.text.TextUtils;
import android.util.Log;
import com.netease.nimlib.log.sdk.LogFormat;
import com.netease.nimlib.log.sdk.util.FileUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public abstract class LogBase {
    static final int K = 1024;
    static final int M = 0x100000;
    private static final int DEFAULT_MAX_LENGTH = 0x800000;
    private static final int DEFAULT_BASE_LENGTH = 0x400000;
    private static final boolean RUN_ON_SINGLE_THREAD = false;
    int maxLength;
    int baseLength;
    String logPath;
    private int level = 3;
    private LogInterceptor interceptor;
    private final Executor logger = Executors.newSingleThreadExecutor();

    public void setLevel(int n) {
        this.level = n;
    }

    public void init(String string, String string2, int n, int n2, int n3, final boolean bl, LogInterceptor logInterceptor) {
        this.logPath = FileUtils.getFilePath(string, string2);
        this.level = n;
        this.interceptor = logInterceptor;
        this.maxLength = n2;
        this.baseLength = n3;
        if (this.maxLength <= 0) {
            this.maxLength = 0x800000;
        }
        if (this.baseLength <= 0) {
            this.baseLength = 0x400000;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LogBase.this.open(bl);
            }
        };
        this.run(runnable);
    }

    public void destroy() {
        if (TextUtils.isEmpty((CharSequence)this.logPath)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LogBase.this.close();
            }
        };
        this.run(runnable);
    }

    public void tryFlush() {
        if (TextUtils.isEmpty((CharSequence)this.logPath)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LogBase.this.forceFlush();
            }
        };
        this.run(runnable);
    }

    private void o(final int n, final String string, final String string2, final Throwable throwable) {
        if (TextUtils.isEmpty((CharSequence)this.logPath) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        final long l = System.currentTimeMillis();
        final long l2 = Thread.currentThread().getId();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string3 = LogFormat.formatTime(l);
                Log.println((int)n, (String)string, (String)(l2 + "/" + string2 + '\n' + Log.getStackTraceString((Throwable)throwable)));
                if (LogBase.this.level <= n && (LogBase.this.interceptor == null || LogBase.this.interceptor.checkValidBeforeWrite())) {
                    LogBase.this.writeLog(LogFormat.formatLog(string, string3, string2, throwable));
                }
            }
        };
        this.run(runnable);
    }

    private void run(Runnable runnable) {
        runnable.run();
    }

    public void i(String string, String string2) {
        this.i(string, string2, null);
    }

    public void i(String string, String string2, Throwable throwable) {
        this.o(4, string, string2, throwable);
    }

    public void v(String string, String string2) {
        this.v(string, string2, null);
    }

    public void v(String string, String string2, Throwable throwable) {
        this.o(2, string, string2, throwable);
    }

    public void e(String string, String string2) {
        this.e(string, string2, null);
    }

    public void e(String string, String string2, Throwable throwable) {
        this.o(6, string, string2, throwable);
    }

    public void d(String string, String string2) {
        this.d(string, string2, null);
    }

    public void d(String string, String string2, Throwable throwable) {
        this.o(3, string, string2, throwable);
    }

    public void w(String string, String string2) {
        this.w(string, string2, null);
    }

    public void w(String string, String string2, Throwable throwable) {
        this.o(5, string, string2, throwable);
    }

    private void o(int n, String string, String string2) {
        this.o(n, string, string2, null);
    }

    abstract void open(boolean var1);

    abstract void writeLog(String var1);

    abstract void forceFlush();

    abstract void close();

    public static interface LogInterceptor {
        public boolean checkValidBeforeWrite();
    }
}

