package com.netease.nimlib.log.sdk;

import android.util.Log;

import com.netease.nimlib.log.core.MMapWriter;

/**
 * MMap方式写日志，不支持多进程读写，写效率高，依赖进程被杀死时，系统回写MMap来保证不丢日志。分进程记录日志，需要merge。
 * <p>
 * Created by huangjun on 2017/3/8.
 */
public class XLogImpl extends LogBase {

    private static final boolean DEBUG = false;

    private MMapWriter mapWriter;

    private NLogImpl debugLog;

    @Override
    public void init(final String logDir, final String logName, final int level,
                     final int maxLength, final int baseLength, final boolean shrink, final LogInterceptor interceptor) {
        super.init(logDir, logName, level, maxLength, baseLength, shrink, interceptor);
        if (DEBUG) {
            debugLog = new NLogImpl();
            debugLog.init(logDir, "debug_" + logName, 0, 0, Log.DEBUG, false, interceptor);
        }
    }

    @Override
    void open(final boolean shrink) {
        if (mapWriter == null) {
            mapWriter = new MMapWriter(maxLength, baseLength, baseLength / (2 * K)); // 8M -> 4M -> 2K
        }
        if (DEBUG) {
            mapWriter.setDebugLog(debugLog);
        }
        mapWriter.open(logPath);
    }

    @Override
    void writeLog(String log) {
        if (mapWriter != null) {
            mapWriter.write(log);
        }
    }

    @Override
    void forceFlush() {
        if (mapWriter != null) {
            mapWriter.forceFlush();
        }
    }

    @Override
    void close() {
        if (mapWriter != null) {
            mapWriter.close();
        }
    }
}
