package com.netease.nimlib.log.sdk;

import com.netease.nimlib.log.core.SimpleMMapWriter;
import com.netease.nimlib.log.sdk.util.FileUtils;

import java.io.File;

/**
 * 结合I/O write 和 MMap 方式，性能和稳定更好，分进程记录日志，需要merge。
 * <p>
 * Created by huangjun on 2017/8/24.
 */

public class MLogImpl extends NLogImpl {

    private SimpleMMapWriter mapWriter;

    private static final String MAPPED_FILE_NAME_SUFFIX = "_mapped";

    @Override
    void open(final boolean shrink) {
        // dest file shrink
        super.open(shrink);

        // dest file
        final String destFilePath = logPath;

        // mapped file
        final String dir = logPath.substring(0, logPath.lastIndexOf(File.separator));
        final String fileName = FileUtils.getFileNameFromPath(logPath);
        String mappedFilePath;
        if (FileUtils.hasExtension(fileName)) {
            final String fileNameNoExt = FileUtils.getFileNameNoEx(fileName);
            final String ext = FileUtils.getExtensionName(fileName);
            mappedFilePath = dir + File.separator + fileNameNoExt + MAPPED_FILE_NAME_SUFFIX + "." + ext;
        } else {
            mappedFilePath = dir + File.separator + fileName + MAPPED_FILE_NAME_SUFFIX;
        }

        // mapped writer
        if (mapWriter == null) {
            mapWriter = new SimpleMMapWriter();
        }

        // open mapped file
        mapWriter.open(mappedFilePath, destFilePath);
    }

    @Override
    void writeLog(String log) {
        if (mapWriter != null) {
            mapWriter.write(log);
        }
    }

    @Override
    void forceFlush() {
        if (mapWriter != null) {
            mapWriter.forceFlush();
        }
    }

    @Override
    void close() {
        if (mapWriter != null) {
            mapWriter.close();
        }
    }
}
